/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.font;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Objects;
import java.util.function.Consumer;
import kasuga.lib.core.client.render.SimpleColor;
import kasuga.lib.core.client.render.font.Font;
import kasuga.lib.core.client.render.font.PivotPosition;
import kasuga.lib.core.client.render.texture.Vec2f;
import kasuga.lib.core.util.ComponentHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;

public class TextContext {
    private final Font font;
    private Style style;
    private Component text;
    private SimpleColor color;
    private Vec2f scale;
    private Vec2f pivot;
    private Vector3f rotation;
    private Vector3f position;
    public static final Vec2f ONE = new Vec2f(1.0f, 1.0f);
    public static final float standardScale = 0.13333334f;
    public static final float negStandardScale = 7.4999995f;
    protected boolean sizeFixure = true;

    public TextContext(Font font, Component component) {
        this.font = font;
        this.text = component;
        this.scale = ONE;
        this.pivot = Vec2f.ZERO;
        this.rotation = Vector3f.f_176763_;
        this.position = Vector3f.f_176763_;
        this.style = null;
        this.color = SimpleColor.fromRGBInt(0xFFFFFF);
    }

    public TextContext(Component component) {
        this(null, component);
    }

    public TextContext(Font font, String text) {
        this(font, (Component)Component.m_237113_((String)text));
    }

    public TextContext(String text) {
        this(null, text);
    }

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public void setPosition(float x, float y, float z) {
        this.position = new Vector3f(x, y, z);
    }

    public void offset(float x, float y, float z) {
        this.position.m_122272_(x, y, z);
    }

    public void offset(Vector3f offset) {
        this.position.m_122253_(offset);
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public float getX() {
        return this.position.m_122239_();
    }

    public float getY() {
        return this.position.m_122260_();
    }

    public float getZ() {
        return this.position.m_122269_();
    }

    public Vec2f getPivot() {
        return this.pivot;
    }

    public void setPivot(Vec2f pivot) {
        this.pivot = pivot;
    }

    public void setPivot(float px, float py) {
        this.pivot = new Vec2f(px, py);
    }

    public void setPivot(PivotPosition position) {
        Vec2f vec = PivotPosition.getPivot(position);
        if (vec == null) {
            return;
        }
        this.pivot = vec;
    }

    public void setScale(Vec2f scale) {
        this.scale = scale;
    }

    public void setScale(float scaleX, float scaleY) {
        this.scale.setX(scaleX);
        this.scale.setY(scaleY);
    }

    public Vec2f getScale() {
        return this.scale;
    }

    public float getScaleX() {
        return this.scale.x();
    }

    public float getScaleY() {
        return this.scale.y();
    }

    public float getWidth() {
        this.getFont().m_131146_(this.text.m_7383_());
        return (float)Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.text) * this.scale.x();
    }

    public float getHeight() {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9.0f * this.scale.y();
    }

    public void setColor(SimpleColor color) {
        this.color = color;
    }

    public SimpleColor getColor() {
        return this.color;
    }

    public Component getText() {
        return this.text;
    }

    public void setText(String text) {
        Style style1 = this.getFont();
        this.text = ComponentHelper.literal(text);
        style1.m_131146_(this.text.m_7383_());
        this.getWidth();
        this.getHeight();
    }

    public void setText(Component text) {
        Style style1 = this.getFont();
        this.text = text;
        style1.m_131146_(text.m_7383_());
        this.getWidth();
        this.getHeight();
    }

    public Style getFont() {
        if (this.style != null) {
            return this.style;
        }
        if (this.font == null) {
            this.style = Style.f_131099_;
            return this.style;
        }
        this.style = this.font.getFont();
        return this.style;
    }

    public void resetFont() {
        this.style = null;
        this.getFont();
    }

    public void rotate(Vector3f rotation) {
        this.rotation.m_122253_(rotation);
    }

    public void rotateDeg(Vector3f rotationDeg) {
        rotationDeg = rotationDeg.m_122281_();
        rotationDeg.m_122261_((float)Math.PI / 180);
        this.rotate(rotationDeg);
    }

    public void rotate(float x, float y, float z) {
        this.rotate(new Vector3f(x, y, z));
    }

    public void rotateDeg(float x, float y, float z) {
        this.rotateDeg(new Vector3f(x, y, z));
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public void setRotation(float x, float y, float z) {
        this.rotation = new Vector3f(x, y, z);
    }

    public void setRotation(Vector3f rotation) {
        this.rotation = rotation;
    }

    public void setInsertion(String insertion) {
        this.getFont().m_131138_(insertion).m_131146_(this.text.m_7383_());
    }

    public void setClickEvent(ClickEvent clickEvent) {
        this.getFont().m_131142_(clickEvent).m_131146_(this.text.m_7383_());
    }

    public void setHoverEvent(HoverEvent event) {
        this.getFont().m_131144_(event).m_131146_(this.text.m_7383_());
    }

    public void applyFormat(ChatFormatting ... formats) {
        this.getFont().m_131152_(formats).m_131146_(this.text.m_7383_());
    }

    public boolean isUnderlined() {
        return this.getFont().m_131171_();
    }

    public void underline(boolean underline) {
        this.getFont().m_131162_(Boolean.valueOf(underline)).m_131146_(this.text.m_7383_());
    }

    public void bold(boolean bold) {
        this.getFont().m_131136_(Boolean.valueOf(bold)).m_131146_(this.text.m_7383_());
    }

    public boolean isBold() {
        return this.getFont().m_131154_();
    }

    public void strikeThrough(boolean strikeThrough) {
        this.getFont().m_178522_(Boolean.valueOf(strikeThrough)).m_131146_(this.text.m_7383_());
    }

    public boolean isStrikeThrough() {
        return this.getFont().m_131168_();
    }

    public void obfuscated(boolean obfuscated) {
        this.getFont().m_178524_(Boolean.valueOf(obfuscated)).m_131146_(this.text.m_7383_());
    }

    public boolean isObfuscated() {
        return this.getFont().m_131176_();
    }

    public void italic(boolean italic) {
        this.getFont().m_131155_(Boolean.valueOf(italic)).m_131146_(this.text.m_7383_());
    }

    public boolean isItalic() {
        return this.getFont().m_131161_();
    }

    public void withoutSizeFixure() {
        this.sizeFixure = false;
    }

    public void renderToGui(PoseStack pose) {
        pose.m_85837_((double)this.position.m_122239_(), (double)this.position.m_122260_(), (double)this.position.m_122269_());
        pose.m_85845_(Quaternion.m_175232_((Vector3f)this.rotation));
        pose.m_85837_((double)(-this.pivot.x() * this.getWidth()), (double)(-this.pivot.y() * this.getHeight()), 0.0);
        pose.m_85841_(this.scale.x(), this.scale.y(), 1.0f);
        Minecraft.m_91087_().f_91062_.m_92889_(pose, this.text, 0.0f, 0.0f, this.color.getRGB());
        pose.m_85841_(1.0f / this.scale.x(), 1.0f / this.scale.y(), 1.0f);
        pose.m_85837_((double)(this.pivot.x() * this.getWidth()), (double)(this.pivot.y() * this.getHeight()), 0.0);
        Vector3f negRot = this.rotation.m_122281_();
        negRot.m_122261_(-1.0f);
        pose.m_85845_(Quaternion.m_175232_((Vector3f)negRot));
        pose.m_85837_((double)(-this.position.m_122239_()), (double)(-this.position.m_122260_()), (double)(-this.position.m_122269_()));
    }

    public void renderToWorld(PoseStack pose, MultiBufferSource source, boolean dropShadow, boolean transparent, SimpleColor bgColor, int light) {
        pose.m_85837_((double)this.position.m_122239_(), (double)this.position.m_122260_(), (double)this.position.m_122269_());
        float w = this.pivot.x() * this.getWidth();
        float h = this.pivot.y() * this.getHeight();
        pose.m_85845_(Quaternion.m_175232_((Vector3f)this.rotation));
        Vector3f negRot = this.rotation.m_122281_();
        pose.m_85837_((double)(-w), (double)h, 0.0);
        if (this.sizeFixure) {
            pose.m_85841_(0.13333334f, -0.13333334f, 0.13333334f);
        }
        pose.m_85841_(1.0f, -1.0f, 1.0f);
        pose.m_85841_(this.scale.x(), this.scale.y(), 1.0f);
        Minecraft.m_91087_().f_91062_.m_92841_(this.text, 0.0f, 0.0f, this.color.getRGB(), dropShadow, pose.m_85850_().m_85861_(), source, transparent, bgColor.getRGB(), light);
        pose.m_85841_(1.0f / this.scale.x(), 1.0f / this.scale.y(), 1.0f);
        pose.m_85841_(7.4999995f, -7.4999995f, 7.4999995f);
        pose.m_85837_((double)w, (double)(-h), 0.0);
        negRot.m_122261_(-1.0f);
        pose.m_85845_(Quaternion.m_175232_((Vector3f)negRot));
        pose.m_85837_((double)(-this.position.m_122239_()), (double)(-this.position.m_122260_()), (double)(-this.position.m_122269_()));
    }

    public void renderToWorld(PoseStack pose, MultiBufferSource source, boolean dropShadow, int light) {
        this.renderToWorld(pose, source, dropShadow, false, SimpleColor.fromRGBA(0, 0, 0, 0), light);
    }

    public void renderToWorld(PoseStack pose, MultiBufferSource source, int light) {
        this.renderToWorld(pose, source, false, light);
    }

    private void transform(PoseStack pose, Consumer<Object> func) {
        func.accept(null);
    }
}

