/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.texture;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import kasuga.lib.core.annos.Util;
import kasuga.lib.core.client.render.SimpleColor;
import kasuga.lib.core.client.render.texture.StaticImage;
import kasuga.lib.core.client.render.texture.Vec2f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public class ImageMask {
    private Vector3f leftTop;
    private Vector3f rightTop;
    private Vector3f leftDown;
    private Vector3f rightDown;
    private Vector3f pivot;
    private Vec2f uvLeftTop;
    private Vec2f uvRightTop;
    private Vec2f uvLeftDown;
    private Vec2f uvRightDown;
    private SimpleColor color;
    public final StaticImage image;

    public ImageMask(StaticImage image) {
        this.image = image;
        this.initialize();
    }

    public void initialize() {
        this.leftTop = new Vector3f(0.0f, 0.0f, 0.0f);
        this.rightTop = new Vector3f((float)this.image.width(), 0.0f, 0.0f);
        this.leftDown = new Vector3f(0.0f, (float)this.image.height(), 0.0f);
        this.rightDown = new Vector3f((float)this.image.width(), (float)this.image.height(), 0.0f);
        this.pivot = new Vector3f((float)this.image.width() / 2.0f, (float)this.image.height() / 2.0f, 0.0f);
        this.uvLeftTop = Vec2f.ZERO;
        this.uvRightTop = Vec2f.ZERO.add(1.0f, 0.0f);
        this.uvLeftDown = Vec2f.ZERO.add(0.0f, 1.0f);
        this.uvRightDown = Vec2f.ZERO.add(1.0f, 1.0f);
        this.color = SimpleColor.fromRGBA(255, 255, 255, 255);
    }

    public ImageMask(ImageMask mask) {
        this.image = mask.image;
        this.leftTop = mask.leftTop.m_122281_();
        this.rightTop = mask.rightTop.m_122281_();
        this.leftDown = mask.leftDown.m_122281_();
        this.rightDown = mask.rightDown.m_122281_();
        this.uvLeftTop = mask.uvLeftTop.copy();
        this.uvRightTop = mask.uvRightTop.copy();
        this.uvLeftDown = mask.uvLeftDown.copy();
        this.uvRightDown = mask.uvRightDown.copy();
        this.pivot = mask.pivot.m_122281_();
        this.color = mask.color.copy();
    }

    public ImageMask(String name, CompoundTag nbt) {
        CompoundTag tag = nbt.m_128469_(name);
        this.image = StaticImage.STACK.get(new ResourceLocation(tag.m_128461_("id"))).get();
        this.leftTop = ImageMask.deserializeVector3f(tag.m_128469_("leftTop"));
        this.leftDown = ImageMask.deserializeVector3f(tag.m_128469_("leftDown"));
        this.rightTop = ImageMask.deserializeVector3f(tag.m_128469_("rightTop"));
        this.rightDown = ImageMask.deserializeVector3f(tag.m_128469_("rightDown"));
        this.uvLeftTop = new Vec2f(tag.m_128469_("uvLeftTop"));
        this.uvRightTop = new Vec2f(tag.m_128469_("uvRightTop"));
        this.uvLeftDown = new Vec2f(tag.m_128469_("uvLeftDown"));
        this.uvRightDown = new Vec2f(tag.m_128469_("uvRightDown"));
        this.color = SimpleColor.fromRGBA(tag.m_128451_("color"), tag.m_128451_("alpha"));
    }

    public ImageMask copyWithOp(ImageMaskOp operation) {
        ImageMask mask = new ImageMask(this);
        return operation.operate(mask);
    }

    public void serialize(String name, CompoundTag nbt) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("leftTop", (Tag)ImageMask.serializeVector3f(this.leftTop));
        tag.m_128365_("leftDown", (Tag)ImageMask.serializeVector3f(this.leftDown));
        tag.m_128365_("rightTop", (Tag)ImageMask.serializeVector3f(this.rightTop));
        tag.m_128365_("rightDown", (Tag)ImageMask.serializeVector3f(this.rightDown));
        tag.m_128365_("uvLeftTop", (Tag)this.uvLeftTop.serialize());
        tag.m_128365_("uvLeftDown", (Tag)this.uvLeftDown.serialize());
        tag.m_128365_("uvRightTop", (Tag)this.uvRightTop.serialize());
        tag.m_128365_("uvRightDown", (Tag)this.uvRightDown.serialize());
        tag.m_128405_("color", this.color.getRGB());
        tag.m_128350_("alpha", this.color.getA());
        tag.m_128359_("id", this.image.id.toString());
        nbt.m_128365_(name, (Tag)tag);
    }

    public void renderToGui() {
        this.image.renderToGui(this);
    }

    public void renderToWorld(PoseStack pose, MultiBufferSource buffer, RenderType type, boolean revert, int light) {
        this.image.renderToWorld(pose, buffer, type, this, revert, light);
    }

    public void renderToGui(PoseStack.Pose pose) {
        this.image.renderToGui(this, pose);
    }

    public StaticImage getImage() {
        return this.image;
    }

    public SimpleColor getColor() {
        return this.color;
    }

    public void setColor(SimpleColor color) {
        this.color = color;
    }

    public ImageMask setPosition(float xLeftTop, float yLeftTop, float zLeftTop, float xRightTop, float yRightTop, float zRightTop, float xLeftDown, float yLeftDown, float zLeftDown, float xRightDown, float yRightDown, float zRightDown) {
        return this.setPosition(new Vector3f(xLeftTop, yLeftTop, zLeftTop), new Vector3f(xRightTop, yRightTop, zRightTop), new Vector3f(xLeftDown, yLeftDown, zLeftDown), new Vector3f(xRightDown, yRightDown, zRightDown));
    }

    public ImageMask setPosition(Vector3f leftTop, Vector3f rightTop, Vector3f leftDown, Vector3f rightDown) {
        this.leftTop = leftTop;
        this.rightTop = rightTop;
        this.leftDown = leftDown;
        this.rightDown = rightDown;
        this.updateMapping();
        return this;
    }

    public ImageMask quadrilateral(Vector3f leftTop, Vector3f xDirection, Vector3f yDirection, float width, float height) {
        this.leftTop = leftTop;
        this.rightTop = leftTop.m_122281_();
        Vector3f w = xDirection.m_122281_();
        w.m_122278_();
        w.m_122261_(width);
        Vector3f h = yDirection.m_122281_();
        h.m_122278_();
        h.m_122261_(height);
        this.rightTop.m_122253_(w);
        this.leftDown = leftTop.m_122281_();
        this.leftDown.m_122253_(h);
        this.rightDown = this.leftDown.m_122281_();
        this.rightDown.m_122253_(w);
        this.updateMapping();
        return this;
    }

    public ImageMask rectangle(Vector3f leftTop, Axis xAxis, Axis yAxis, boolean xPositive, boolean yPositive, float width, float height) {
        if (xAxis.equals((Object)yAxis)) {
            return this;
        }
        Vector3f xDirection = this.getDirectionVector(xAxis, xPositive);
        Vector3f yDirection = this.getDirectionVector(yAxis, yPositive);
        return this.quadrilateral(leftTop, xDirection, yDirection, width, height);
    }

    private Vector3f getDirectionVector(Axis axis, boolean positive) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> {
                if (positive) {
                    yield new Vector3f(1.0f, 0.0f, 0.0f);
                }
                yield new Vector3f(-1.0f, 0.0f, 0.0f);
            }
            case Axis.Y -> {
                if (positive) {
                    yield new Vector3f(0.0f, 1.0f, 0.0f);
                }
                yield new Vector3f(0.0f, -1.0f, 0.0f);
            }
            case Axis.Z -> positive ? new Vector3f(0.0f, 0.0f, 1.0f) : new Vector3f(0.0f, 0.0f, -1.0f);
        };
    }

    public ImageMask offset(float x, float y, float z) {
        this.leftDown.m_122272_(x, y, z);
        this.rightDown.m_122272_(x, y, z);
        this.leftTop.m_122272_(x, y, z);
        this.rightTop.m_122272_(x, y, z);
        this.updateMapping();
        return this;
    }

    public ImageMask offset(Vector3f offset) {
        this.leftDown.m_122253_(offset);
        this.rightDown.m_122253_(offset);
        this.leftTop.m_122253_(offset);
        this.rightTop.m_122253_(offset);
        this.updateMapping();
        return this;
    }

    public ImageMask offsetPivot(Vector3f offset) {
        this.pivot.m_122253_(offset);
        return this;
    }

    public ImageMask offsetPivot(float x, float y, float z) {
        this.pivot.m_122272_(x, y, z);
        return this;
    }

    public ImageMask offsetWithPivot(Vector3f offset) {
        this.offset(offset);
        this.offsetPivot(offset);
        return this;
    }

    public ImageMask offsetWithPivot(float x, float y, float z) {
        this.offset(x, y, z);
        this.offsetPivot(x, y, z);
        return this;
    }

    public ImageMask rotateX(float rad) {
        return this.rotateByPivot(rad, 0.0f, 0.0f);
    }

    public ImageMask rotateY(float rad) {
        return this.rotateByPivot(0.0f, rad, 0.0f);
    }

    public ImageMask rotateZ(float rad) {
        return this.rotateByPivot(0.0f, 0.0f, rad);
    }

    public ImageMask rotateByPivot(float radX, float radY, float radZ) {
        return this.rotateByPivot(new Vector3f(radX, radY, radZ));
    }

    public ImageMask rotateByPivot(Vector3f rotationRad) {
        return this.rotateByPivot(this.pivot, rotationRad);
    }

    public ImageMask rotateByPivot(Vector3f pivot, Vector3f rotationRad) {
        Quaternion quaternion = Quaternion.m_175232_((Vector3f)rotationRad);
        this.leftTop = ImageMask.rotatePoint(this.leftTop, pivot, quaternion);
        this.rightTop = ImageMask.rotatePoint(this.rightTop, pivot, quaternion);
        this.leftDown = ImageMask.rotatePoint(this.leftDown, pivot, quaternion);
        this.rightDown = ImageMask.rotatePoint(this.rightDown, pivot, quaternion);
        this.updateMapping();
        return this;
    }

    public ImageMask rotateDegX(float deg) {
        return this.rotateByPivotDeg(deg, 0.0f, 0.0f);
    }

    public ImageMask rotateDegY(float deg) {
        return this.rotateByPivotDeg(0.0f, deg, 0.0f);
    }

    public ImageMask rotateDegZ(float deg) {
        return this.rotateByPivotDeg(0.0f, 0.0f, deg);
    }

    public ImageMask rotateByPivotDeg(float degX, float degY, float degZ) {
        return this.rotateByPivotDeg(new Vector3f(degX, degY, degZ));
    }

    public ImageMask rotateByPivotDeg(Vector3f pivot, float degX, float degY, float degZ) {
        return this.rotateByPivotDeg(pivot, new Vector3f(degX, degY, degZ));
    }

    public ImageMask rotateByPivotDeg(Vector3f rotationDeg) {
        return this.rotateByPivotDeg(this.pivot, rotationDeg);
    }

    public ImageMask rotateByPivotDeg(Vector3f pivot, Vector3f rotationDeg) {
        Vector3f rad = rotationDeg.m_122281_();
        rad.m_122261_((float)Math.PI / 180);
        return this.rotateByPivot(pivot, rad);
    }

    public ImageMask flip(Vector3f pivot, Axis axis) {
        this.leftTop = ImageMask.flipPoint(this.leftTop, pivot, axis);
        this.leftDown = ImageMask.flipPoint(this.leftDown, pivot, axis);
        this.rightTop = ImageMask.flipPoint(this.rightTop, pivot, axis);
        this.rightDown = ImageMask.flipPoint(this.rightDown, pivot, axis);
        this.updateMapping();
        return this;
    }

    public ImageMask flipByGeometricCenter(Axis axis) {
        Vector3f geometricCenter = this.getGeometricCenter();
        return this.flip(geometricCenter, axis);
    }

    public ImageMask flipByPivot(Axis axis) {
        return this.flip(this.pivot, axis);
    }

    public ImageMask flipByLeftTop(Axis axis) {
        return this.flip(this.leftTop, axis);
    }

    public ImageMask flipByZero(Axis axis) {
        return this.flip(Vector3f.f_176763_, axis);
    }

    public ImageMask scale(Vector3f pivot, float factor) {
        this.leftTop = ImageMask.scalePoint(this.leftTop, pivot, factor);
        this.leftDown = ImageMask.scalePoint(this.leftDown, pivot, factor);
        this.rightDown = ImageMask.scalePoint(this.rightDown, pivot, factor);
        this.rightTop = ImageMask.scalePoint(this.rightTop, pivot, factor);
        this.updateMapping();
        return this;
    }

    public ImageMask scaleByPivot(float factor) {
        return this.scale(this.pivot, factor);
    }

    public ImageMask scaleByGeometricCenter(float factor) {
        return this.scale(this.getGeometricCenter(), factor);
    }

    public ImageMask scaleByLeftTop(float factor) {
        return this.scale(this.leftTop, factor);
    }

    public ImageMask scaleByZero(float factor) {
        return this.scale(Vector3f.f_176763_, factor);
    }

    public void setLeftTop(float x, float y, float z) {
        this.leftTop = new Vector3f(x, y, z);
    }

    public void setRightTop(float x, float y, float z) {
        this.rightTop = new Vector3f(x, y, z);
    }

    public void setLeftDown(float x, float y, float z) {
        this.leftDown = new Vector3f(x, y, z);
    }

    public void setRightDown(float x, float y, float z) {
        this.rightDown = new Vector3f(x, y, z);
    }

    public void setLeftTop(Vector3f leftTop) {
        this.leftTop = leftTop;
    }

    public void setRightTop(Vector3f rightTop) {
        this.rightTop = rightTop;
    }

    public void setLeftDown(Vector3f leftDown) {
        this.leftDown = leftDown;
    }

    public void setRightDown(Vector3f rightDown) {
        this.rightDown = rightDown;
    }

    public Vector3f getLeftTop() {
        return this.leftTop;
    }

    public Vector3f getRightTop() {
        return this.rightTop;
    }

    public Vector3f getLeftDown() {
        return this.leftDown;
    }

    public Vector3f getRightDown() {
        return this.rightDown;
    }

    public ImageMask setUV(Vec2f leftTop, Vec2f rightTop, Vec2f leftDown, Vec2f rightDown) {
        this.uvLeftTop = leftTop;
        this.uvRightTop = rightTop;
        this.uvLeftDown = leftDown;
        this.uvRightDown = rightDown;
        this.updateMapping();
        return this;
    }

    public ImageMask setUV(float leftTopX, float leftTopY, float rightTopX, float rightTopY, float leftDownX, float leftDownY, float rightDownX, float rightDownY) {
        return this.setUV(new Vec2f(leftTopX, leftTopY), new Vec2f(rightTopX, rightTopY), new Vec2f(leftDownX, leftDownY), new Vec2f(rightDownX, rightDownY));
    }

    public ImageMask rectangleUV(Vec2f leftTop, Vec2f rightDown) {
        this.uvLeftTop = leftTop;
        this.uvRightDown = rightDown;
        this.uvLeftDown = new Vec2f(leftTop.x(), rightDown.y());
        this.uvRightTop = new Vec2f(rightDown.x(), leftTop.y());
        this.updateMapping();
        return this;
    }

    public ImageMask rectangleUV(float leftTopX, float leftTopY, float rightDownX, float rightDownY) {
        return this.rectangleUV(new Vec2f(leftTopX, leftTopY), new Vec2f(rightDownX, rightDownY));
    }

    public ImageMask offsetUV(Vec2f offset) {
        Vec2f normalOffset = offset.scale(1.0f / (float)this.image.width(), 1.0f / (float)this.image.height());
        this.uvLeftTop.add(normalOffset);
        this.uvLeftDown.add(normalOffset);
        this.uvRightTop.add(normalOffset);
        this.uvRightDown.add(normalOffset);
        this.updateMapping();
        return this;
    }

    public ImageMask scaleUV(Vec2f pivot, float factor) {
        this.uvLeftTop = ImageMask.scaleUVPoint(this.uvLeftTop, pivot, factor);
        this.uvLeftDown = ImageMask.scaleUVPoint(this.uvLeftDown, pivot, factor);
        this.uvRightTop = ImageMask.scaleUVPoint(this.uvRightTop, pivot, factor);
        this.uvRightDown = ImageMask.scaleUVPoint(this.uvRightDown, pivot, factor);
        this.updateMapping();
        return this;
    }

    public ImageMask scaleUVByGeometricCenter(float factor) {
        this.uvLeftTop = ImageMask.scaleUVPoint(this.uvLeftTop, this.getUvGeometricCenter(), factor);
        this.uvRightTop = ImageMask.scaleUVPoint(this.uvRightTop, this.getUvGeometricCenter(), factor);
        this.uvLeftDown = ImageMask.scaleUVPoint(this.uvLeftDown, this.getUvGeometricCenter(), factor);
        this.uvRightDown = ImageMask.scaleUVPoint(this.uvRightDown, this.getUvGeometricCenter(), factor);
        this.updateMapping();
        return this;
    }

    public ImageMask scaleUVByZero(float factor) {
        this.uvLeftTop = ImageMask.scaleUVPoint(this.uvLeftTop, Vec2f.ZERO, factor);
        this.uvLeftDown = ImageMask.scaleUVPoint(this.uvLeftDown, Vec2f.ZERO, factor);
        this.uvRightDown = ImageMask.scaleUVPoint(this.uvRightDown, Vec2f.ZERO, factor);
        this.uvRightTop = ImageMask.scaleUVPoint(this.uvRightTop, Vec2f.ZERO, factor);
        this.updateMapping();
        return this;
    }

    public ImageMask rotateUVByGeometricCenter(float rad) {
        return this.rotateUV(this.getUvGeometricCenter(), rad);
    }

    public ImageMask rotateUVByGeometricCenterDeg(float deg) {
        return this.rotateUVDeg(this.getUvGeometricCenter(), deg);
    }

    public ImageMask rotateUVByZero(float rad) {
        return this.rotateUV(Vec2f.ZERO, rad);
    }

    public ImageMask rotateUVByZeroDeg(float deg) {
        return this.rotateUVDeg(Vec2f.ZERO, deg);
    }

    public ImageMask rotateUVByLeftTop(float rad) {
        return this.rotateUV(this.uvLeftTop, rad);
    }

    public ImageMask rotateUVByLeftTopDeg(float deg) {
        return this.rotateUVDeg(this.uvLeftTop, deg);
    }

    public ImageMask rotateUV(Vec2f pivot, float rad) {
        this.uvLeftTop = this.uvLeftTop.rotate(pivot, rad);
        this.uvLeftDown = this.uvLeftDown.rotate(pivot, rad);
        this.uvRightDown = this.uvRightDown.rotate(pivot, rad);
        this.uvRightTop = this.uvRightTop.rotate(pivot, rad);
        this.updateMapping();
        return this;
    }

    public ImageMask rotateUVDeg(Vec2f pivot, float deg) {
        return this.rotateUV(pivot, deg * (float)Math.PI / 180.0f);
    }

    public ImageMask flipUVByGeometricCenter(Axis axis) {
        return this.flipUV(this.getUvGeometricCenter(), axis);
    }

    public ImageMask flipUVByZero(Axis axis) {
        return this.flipUV(Vec2f.ZERO, axis);
    }

    public ImageMask flipUVByLeftTop(Axis axis) {
        return this.flipUV(this.uvLeftTop, axis);
    }

    public ImageMask flipUV(Vec2f pivot, Axis axis) {
        this.uvLeftTop = ImageMask.flipVUPoint(this.uvLeftTop, pivot, axis);
        this.uvRightTop = ImageMask.flipVUPoint(this.uvRightTop, pivot, axis);
        this.uvLeftDown = ImageMask.flipVUPoint(this.uvLeftDown, pivot, axis);
        this.uvRightDown = ImageMask.flipVUPoint(this.uvRightDown, pivot, axis);
        this.updateMapping();
        return this;
    }

    public Vec2f getUvLeftTop() {
        return this.uvLeftTop;
    }

    public Vec2f getUvLeftDown() {
        return this.uvLeftDown;
    }

    public Vec2f getUvRightDown() {
        return this.uvRightDown;
    }

    public Vec2f getUvRightTop() {
        return this.uvRightTop;
    }

    public Vector3f getPivot() {
        return this.pivot;
    }

    public void setPivot(Vector3f pivot) {
        this.pivot = pivot;
    }

    public void setUvLeftDown(Vec2f uvLeftDown) {
        this.uvLeftDown = uvLeftDown;
    }

    public void setUvLeftTop(Vec2f uvLeftTop) {
        this.uvLeftTop = uvLeftTop;
    }

    public void setUvRightDown(Vec2f uvRightDown) {
        this.uvRightDown = uvRightDown;
    }

    public void setUvRightTop(Vec2f uvRightTop) {
        this.uvRightTop = uvRightTop;
    }

    public Vector3f getGeometricCenter() {
        Vector3f result = this.leftTop.m_122281_();
        result.m_122253_(this.leftDown);
        result.m_122253_(this.rightTop);
        result.m_122253_(this.rightDown);
        result.m_122261_(0.25f);
        return result;
    }

    public ImageMask setPivotAsGeometricCenter() {
        this.pivot = this.getGeometricCenter();
        return this;
    }

    public Vec2f getUvGeometricCenter() {
        return Vec2f.average(this.uvLeftTop, this.uvLeftDown, this.uvRightDown, this.uvRightTop);
    }

    public void updateMapping() {
    }

    @Util
    public static Vector3f rotatePoint(Vector3f point, Vector3f pivot, Quaternion quaternion) {
        Vector3f offset = point.m_122281_();
        offset.m_122267_(pivot);
        offset.m_122251_(quaternion);
        Vector3f result = pivot.m_122281_();
        result.m_122253_(offset);
        return result;
    }

    @Util
    public static Vector3f flipPoint(Vector3f point, Vector3f pivot, Axis axis) {
        Vector3f offset = point.m_122281_();
        offset.m_122267_(pivot);
        switch (axis) {
            case X: {
                offset.setX(-offset.m_122239_());
                break;
            }
            case Y: {
                offset.setY(-offset.m_122260_());
                break;
            }
            case Z: {
                offset.setZ(-offset.m_122269_());
            }
        }
        offset.m_122253_(pivot);
        return offset;
    }

    @Util
    public static Vec2f flipVUPoint(Vec2f point, Vec2f pivot, Axis axis) {
        Vec2f offset = point.subtract(pivot);
        switch (axis) {
            case X: {
                offset.setX(-offset.x());
                break;
            }
            case Y: {
                offset.setY(-offset.y());
            }
        }
        return offset.add(pivot);
    }

    @Util
    public static Vector3f scalePoint(Vector3f point, Vector3f pivot, float factor) {
        Vector3f offset = pivot.m_122281_();
        offset.m_122267_(point);
        offset.m_122261_(factor);
        offset.m_122253_(point);
        return offset;
    }

    @Util
    public static Vec2f scaleUVPoint(Vec2f point, Vec2f pivot, float factor) {
        return pivot.subtract(point).scale(factor).add(point);
    }

    @Util
    public static CompoundTag serializeVector3f(Vector3f vector3f) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("x", vector3f.m_122239_());
        nbt.m_128350_("y", vector3f.m_122260_());
        nbt.m_128350_("z", vector3f.m_122269_());
        return nbt;
    }

    @Util
    public static Vector3f deserializeVector3f(CompoundTag nbt) {
        return new Vector3f(nbt.m_128457_("x"), nbt.m_128457_("y"), nbt.m_128457_("z"));
    }

    @FunctionalInterface
    @Util
    public static interface ImageMaskOp {
        public ImageMask operate(ImageMask var1);
    }

    @Util
    public static enum Axis implements StringRepresentable
    {
        X,
        Y,
        Z;


        @NotNull
        public String m_7912_() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case X -> "x";
                case Y -> "y";
                case Z -> "z";
            };
        }

        @NotNull
        public static Axis fromSerializedName(String input) {
            return switch (input) {
                case "x" -> X;
                case "y" -> Y;
                case "z" -> Z;
                default -> throw new IllegalArgumentException("Illegal input: " + input);
            };
        }
    }
}

