/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.annos.Inner;
import kasuga.lib.core.client.render.SimpleColor;
import kasuga.lib.core.client.render.texture.ImageMask;
import kasuga.lib.core.client.render.texture.NineSlicedImageMask;
import kasuga.lib.core.client.render.texture.StaticImageHolder;
import kasuga.lib.core.client.render.texture.Vec2f;
import kasuga.lib.core.util.Resources;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class StaticImage {
    public static final HashMap<ResourceLocation, Supplier<StaticImage>> STACK = new HashMap();
    public static final HashSet<StaticImageHolder> HOLDERS = new HashSet();
    public final ResourceLocation id;
    public final BufferedImage image;
    public final byte[] rawData;

    private StaticImage(ResourceLocation id) throws IOException {
        this.id = id;
        Resource resource = Resources.getResource(id);
        this.rawData = resource.m_215507_().readAllBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(this.rawData);
        this.image = ImageIO.read(stream);
    }

    private StaticImage(ResourceLocation id, InputStream inputStream) throws IOException {
        this.id = id;
        this.rawData = inputStream.readAllBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(this.rawData);
        this.image = ImageIO.read(stream);
        stream.close();
    }

    private StaticImage(ResourceLocation id, byte[] bytes) throws IOException {
        this.id = id;
        this.rawData = bytes;
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        this.image = ImageIO.read(stream);
    }

    @Inner
    public static Supplier<StaticImage> createImage(FriendlyByteBuf buf) throws IOException {
        ResourceLocation location = buf.m_130281_();
        byte[] bytes = buf.m_130052_();
        return StaticImage.createImage(location, new ByteArrayInputStream(bytes));
    }

    @Inner
    public static Supplier<StaticImage> createImage(CompoundTag nbt) throws IOException {
        return StaticImage.createImage(new ResourceLocation(nbt.m_128461_("id_namespace"), nbt.m_128461_("id_path")), new ByteArrayInputStream(nbt.m_128463_("data")));
    }

    @Inner
    public static Supplier<StaticImage> createImage(ResourceLocation id, InputStream inputStream) throws IOException {
        if (STACK.containsKey(id)) {
            return STACK.get(id);
        }
        Resources.CheatResourceLocation cheat = Resources.CheatResourceLocation.copy(id);
        StaticImage image = new StaticImage((ResourceLocation)cheat, inputStream);
        ByteArrayInputStream stream = new ByteArrayInputStream(image.rawData);
        StaticImage.registerImageToMc(cheat, stream);
        stream.close();
        STACK.put(image.id, () -> image);
        return () -> image;
    }

    @Inner
    public static Supplier<StaticImage> createImage(ResourceLocation id) throws IOException {
        if (STACK.containsKey(id)) {
            return STACK.get(id);
        }
        StaticImage image1 = new StaticImage(id);
        ByteArrayInputStream stream = new ByteArrayInputStream(image1.rawData);
        StaticImage.registerLocalImageToMc(image1.id, stream);
        stream.close();
        return () -> image1;
    }

    private static DynamicTexture registerLocalImageToMc(ResourceLocation id, InputStream stream) throws IOException {
        NativeImage image = NativeImage.m_85058_((InputStream)stream);
        DynamicTexture texture = new DynamicTexture(image);
        Minecraft.m_91087_().f_90987_.m_118495_(id, (AbstractTexture)texture);
        return texture;
    }

    private static DynamicTexture registerImageToMc(Resources.CheatResourceLocation id, InputStream stream) throws IOException {
        if (!KasugaLib.STACKS.isTextureRegistryFired()) {
            // empty if block
        }
        NativeImage image = NativeImage.m_85058_((InputStream)stream);
        DynamicTexture texture = new DynamicTexture(image);
        Minecraft.m_91087_().f_90987_.m_118495_((ResourceLocation)id, (AbstractTexture)texture);
        return texture;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130085_(this.id);
        buf.m_130087_(this.rawData);
    }

    public void serialize(CompoundTag nbt) {
        nbt.m_128359_("id_namespace", this.id.m_135827_());
        nbt.m_128359_("id_path", this.id.m_135815_());
        nbt.m_128382_("data", this.rawData);
    }

    public int hashCode() {
        return Arrays.hashCode(this.rawData);
    }

    public void renderToGui(Vector3f leftTop, Vector3f rightTop, Vector3f leftDown, Vector3f rightDown, Vec2f uvLeftTop, Vec2f uvRightTop, Vec2f uvLeftDown, Vec2f uvRightDown, SimpleColor color) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.id);
        RenderSystem.m_157429_((float)color.getfR(), (float)color.getfG(), (float)color.getfB(), (float)color.getA());
        RenderSystem.m_69478_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)leftTop.m_122239_(), (double)leftTop.m_122260_(), (double)leftDown.m_122269_()).m_7421_(uvLeftTop.x(), uvLeftTop.y()).m_5752_();
        buffer.m_5483_((double)leftDown.m_122239_(), (double)leftDown.m_122260_(), (double)leftDown.m_122269_()).m_7421_(uvLeftDown.x(), uvLeftDown.y()).m_5752_();
        buffer.m_5483_((double)rightDown.m_122239_(), (double)rightDown.m_122260_(), (double)rightDown.m_122269_()).m_7421_(uvRightDown.x(), uvRightDown.y()).m_5752_();
        buffer.m_5483_((double)rightTop.m_122239_(), (double)rightTop.m_122260_(), (double)rightTop.m_122269_()).m_7421_(uvRightTop.x(), uvRightTop.y()).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.m_69461_();
    }

    public void renderToGui(ImageMask mask) {
        this.renderToGui(mask.getLeftTop(), mask.getRightTop(), mask.getLeftDown(), mask.getRightDown(), mask.getUvLeftTop(), mask.getUvRightTop(), mask.getUvLeftDown(), mask.getUvRightDown(), mask.getColor());
    }

    public void renderToGui(PoseStack.Pose pose, Vector3f leftTop, Vector3f rightTop, Vector3f leftDown, Vector3f rightDown, Vec2f uvLeftTop, Vec2f uvRightTop, Vec2f uvLeftDown, Vec2f uvRightDown, SimpleColor color) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.id);
        RenderSystem.m_157429_((float)color.getfR(), (float)color.getfG(), (float)color.getfB(), (float)color.getA());
        RenderSystem.m_69478_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f poseMatrix = pose.m_85861_();
        buffer.m_85982_(poseMatrix, leftTop.m_122239_(), leftTop.m_122260_(), leftDown.m_122269_()).m_7421_(uvLeftTop.x(), uvLeftTop.y()).m_5752_();
        buffer.m_85982_(poseMatrix, leftDown.m_122239_(), leftDown.m_122260_(), leftDown.m_122269_()).m_7421_(uvLeftDown.x(), uvLeftDown.y()).m_5752_();
        buffer.m_85982_(poseMatrix, rightDown.m_122239_(), rightDown.m_122260_(), rightDown.m_122269_()).m_7421_(uvRightDown.x(), uvRightDown.y()).m_5752_();
        buffer.m_85982_(poseMatrix, rightTop.m_122239_(), rightTop.m_122260_(), rightTop.m_122269_()).m_7421_(uvRightTop.x(), uvRightTop.y()).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.m_69461_();
    }

    public void renderToGui(ImageMask mask, PoseStack.Pose pose) {
        this.renderToGui(pose, mask.getLeftTop(), mask.getRightTop(), mask.getLeftDown(), mask.getRightDown(), mask.getUvLeftTop(), mask.getUvRightTop(), mask.getUvLeftDown(), mask.getUvRightDown(), mask.getColor());
    }

    public void renderToWorld(PoseStack pose, MultiBufferSource buffer, RenderType type, Vector3f leftTop, Vector3f rightTop, Vector3f leftDown, Vector3f rightDown, Vec2f uvLeftTop, Vec2f uvRightTop, Vec2f uvLeftDown, Vec2f uvRightDown, SimpleColor color, boolean reverse, int light) {
        pose.m_85836_();
        if (!reverse) {
            pose.m_85841_(1.0f, -1.0f, 1.0f);
        }
        pose.m_85837_(0.5, 0.0, 0.5);
        Matrix4f matrix = pose.m_85850_().m_85861_();
        VertexConsumer consumer = buffer.m_6299_(type);
        this.buildVertex(consumer, matrix, leftTop, uvLeftTop, color, light);
        this.buildVertex(consumer, matrix, leftDown, uvLeftDown, color, light);
        this.buildVertex(consumer, matrix, rightDown, uvRightDown, color, light);
        this.buildVertex(consumer, matrix, rightTop, uvRightTop, color, light);
        pose.m_85849_();
    }

    public void renderToWorld(PoseStack pose, MultiBufferSource buffer, RenderType type, ImageMask mask, boolean reverse, int light) {
        this.renderToWorld(pose, buffer, type, mask.getLeftTop(), mask.getRightTop(), mask.getLeftDown(), mask.getRightDown(), mask.getUvLeftTop(), mask.getUvRightTop(), mask.getUvLeftDown(), mask.getUvRightDown(), mask.getColor(), reverse, light);
    }

    private void buildVertex(VertexConsumer consumer, Matrix4f matrix, Vector3f pos, Vec2f uv, SimpleColor color, int light) {
        consumer.m_85982_(matrix, pos.m_122239_(), pos.m_122260_(), pos.m_122269_()).m_85950_(color.getfR(), color.getfG(), color.getfB(), color.getA()).m_7421_(uv.x(), uv.y()).m_85969_(light).m_5752_();
    }

    public ImageMask getMask() {
        return new ImageMask(this);
    }

    public NineSlicedImageMask getNineSlicedMask() {
        return new NineSlicedImageMask(this);
    }

    public int width() {
        return this.image.getWidth();
    }

    public int height() {
        return this.image.getHeight();
    }
}

