/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.imageio.ImageIO;
import kasuga.lib.core.client.render.SimpleColor;
import kasuga.lib.core.client.render.texture.GraphicsImage;
import kasuga.lib.core.client.render.texture.RenderTypeBuilder;
import kasuga.lib.core.util.Resources;
import kasuga.lib.core.util.data_type.Pair;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.Nullable;

public class Texture
extends GraphicsImage<Texture> {
    @Nullable
    protected ResourceLocation location;
    @Nullable
    protected BufferedImage image;
    @Nullable
    protected byte[] rawImage;
    protected SimpleColor color;
    Pair<RenderTypeBuilder, RenderType> renderTypeCache;

    protected Texture(@Nullable ResourceLocation location, @Nullable BufferedImage image, @Nullable byte[] rawImage, float uOffset, float vOffset, float uWidth, float vHeight, float imageWidth, float imageHeight, SimpleColor color) {
        super(uOffset, vOffset, uWidth, vHeight, imageWidth, imageHeight);
        this.location = location;
        this.color = color;
        this.image = image;
        this.updateRawImage(rawImage, false);
        this.readImageInfo();
        this.setUV(uOffset, vOffset, uWidth, vHeight);
    }

    protected void updateRawImage(byte[] rawImage, boolean force) {
        if (this.rawImage == rawImage && !force) {
            return;
        }
        if (rawImage != null) {
            this.rawImage = rawImage;
            return;
        }
        if (this.location == null || Objects.equals(this.location.m_135827_(), "kasuga_lib_tempory")) {
            throw new IllegalStateException("Cannot initilize image with both no RawImage and ResourceLocation");
        }
        this.rawImage = Texture.getRawImageFromLocation(this.location);
        this.updateImage(null, force);
    }

    protected void updateImage(BufferedImage image, boolean force) {
        if (this.image != null && !force) {
            return;
        }
        if (image != null) {
            this.image = image;
            return;
        }
        if (this.rawImage == null || Objects.equals(this.location.m_135827_(), "kasuga_lib_tempory")) {
            throw new IllegalStateException("Cannot initilize image with both no RawImage and ResourceLocation");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.rawImage);){
            this.image = ImageIO.read(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static byte[] getRawImageFromLocation(ResourceLocation location) {
        try {
            Resource resource = Resources.getResource(location);
            InputStream stream = resource.m_215507_();
            return stream.readAllBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Texture cloneTexture() {
        return new Texture(this.location, this.image, this.rawImage, this.uOffset, this.vOffset, this.uWidth, this.vHeight, this.imageWidth, this.imageHeight, this.color);
    }

    public void render(float x, float y, float width, float height) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.location);
        RenderSystem.m_157429_((float)this.color.getfR(), (float)this.color.getfG(), (float)this.color.getfB(), (float)this.color.getA());
        RenderSystem.m_69478_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)x, (double)y, 0.0).m_7421_(this.uOffsetUVCache, this.vOffsetUVCache).m_5752_();
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_7421_(this.uOffsetUVCache, this.vOffsetUVCache + this.vHeightUVCache).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_7421_(this.uOffsetUVCache + this.uWidthUVCache, this.vOffsetUVCache + this.vHeightUVCache).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, 0.0).m_7421_(this.uOffsetUVCache + this.uWidthUVCache, this.vOffsetUVCache).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.m_69461_();
    }

    protected void readImageInfo() {
        this.imageWidth = this.image.getWidth();
        this.imageHeight = this.image.getHeight();
    }

    protected void buildVertex(VertexConsumer consumer, Matrix4f matrix, float x, float y, float z, float u, float v, SimpleColor color, int light) {
        consumer.m_85982_(matrix, x, y, z).m_85950_(color.getfR(), color.getfG(), color.getfB(), color.getA()).m_7421_(u, v).m_85969_(light).m_5752_();
    }

    public void render(RenderTypeBuilder builder, PoseStack pose, MultiBufferSource buffer, float width, float height, int light) {
        if (builder == null) {
            return;
        }
        if (this.renderTypeCache == null || this.renderTypeCache.getFirst() != builder) {
            this.renderTypeCache = Pair.of(builder, builder.build(this.location));
        }
        boolean shouldPush = !pose.m_85851_();
        Matrix4f lastMatrix = null;
        if (shouldPush) {
            pose.m_85836_();
        } else {
            lastMatrix = pose.m_85850_().m_85861_();
            pose.m_85849_();
            pose.m_85836_();
        }
        pose.m_85841_(1.0f, -1.0f, 1.0f);
        pose.m_85837_(0.5, 0.0, 0.5);
        this.poseContext.apply(pose);
        Matrix4f matrix = pose.m_85850_().m_85861_();
        VertexConsumer consumer = buffer.m_6299_(this.renderTypeCache.getSecond());
        this.buildVertex(consumer, matrix, 0.0f, height, 0.0f, this.uOffsetUVCache, this.vOffsetUVCache + this.vHeightUVCache, this.color, light);
        this.buildVertex(consumer, matrix, width, height, 0.0f, this.uOffsetUVCache + this.uWidthUVCache, this.vOffsetUVCache + this.vHeightUVCache, this.color, light);
        this.buildVertex(consumer, matrix, width, 0.0f, 0.0f, this.uOffsetUVCache + this.uWidthUVCache, this.vOffsetUVCache, this.color, light);
        this.buildVertex(consumer, matrix, 0.0f, 0.0f, 0.0f, this.uOffsetUVCache, this.vOffsetUVCache, this.color, light);
        pose.m_85849_();
        if (!shouldPush) {
            pose.m_85836_();
            pose.m_166854_(lastMatrix);
        }
    }
}

