/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.texture;

import kasuga.lib.core.annos.Util;
import kasuga.lib.core.util.data_type.Vec2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;

@Util
public class Vec2f {
    private float x;
    private float y;
    public static final Vec2f ZERO = new Vec2f(0.0f, 0.0f);

    public Vec2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vec2f(Vec2f from) {
        this.x = from.x;
        this.y = from.y;
    }

    public Vec2f(Vec2i vec2i) {
        this.x = vec2i.x;
        this.y = vec2i.y;
    }

    public Vec2f(CompoundTag nbt) {
        this.x = nbt.m_128457_("x");
        this.y = nbt.m_128457_("y");
    }

    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("x", this.x);
        nbt.m_128350_("y", this.y);
        return nbt;
    }

    public Vec2f copy() {
        return new Vec2f(this);
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public Vec2f set(float x, float y) {
        return this.setX(x).setY(y);
    }

    public float[] get() {
        return new float[]{this.x, this.y};
    }

    public Vec2f setX(float x) {
        this.x = x;
        return this;
    }

    public Vec2f setY(float y) {
        this.y = y;
        return this;
    }

    public Vec2f add(float x, float y) {
        return new Vec2f(this.x + x, this.y + y);
    }

    public Vec2f add(Vec2f vec2f) {
        return new Vec2f(this.x + vec2f.x, this.y + vec2f.y);
    }

    public Vec2f subtract(float x, float y) {
        return new Vec2f(this.x - x, this.y - y);
    }

    public Vec2f subtract(Vec2f vec2f) {
        return new Vec2f(this.x - vec2f.x, this.y - vec2f.y);
    }

    public Vec2f scale(float x, float y) {
        return new Vec2f(this.x * x, this.y * y);
    }

    public Vec2f scale(float factor) {
        return this.scale(factor, factor);
    }

    public Vec2f scale(Vec2f vec2f) {
        return new Vec2f(this.x * vec2f.x, this.y * vec2f.y);
    }

    public float dot(Vec2f vec2f) {
        return this.x * vec2f.x + this.y * vec2f.y;
    }

    public float cross(Vec2f vec2f) {
        return this.x * vec2f.y - vec2f.x * this.y;
    }

    public Vec2f normal() {
        return this.scale(Vec2f.fastInvSqrt(this.lengthSqr()));
    }

    public boolean isPerpendicular(Vec2f vec2f) {
        return this.dot(vec2f) == 0.0f;
    }

    public boolean isParallel(Vec2f vec2f) {
        if (this.x == 0.0f) {
            if (this.y == 0.0f) {
                return vec2f.x == this.x && vec2f.y == this.y;
            }
            return vec2f.x == this.x;
        }
        if (this.y == 0.0f) {
            return vec2f.y == this.y;
        }
        return vec2f.x / this.x == vec2f.y / this.y;
    }

    public Vec2f invert() {
        return new Vec2f(-this.x, -this.y);
    }

    public Vec2f rotateDeg(Vec2f pivot, float deg) {
        return this.rotate(pivot, deg / 180.0f * (float)Math.PI);
    }

    public Vec2f rotateDeg(float deg) {
        return this.rotateDeg(ZERO, deg);
    }

    public Vec2f rotate(Vec2f pivot, float rad) {
        Vec2f offset = this.subtract(pivot);
        float x0 = offset.x();
        float y0 = offset.y();
        offset.setX((float)((double)x0 * Math.cos(rad) - (double)y0 * Math.sin(rad)));
        offset.setY((float)((double)y0 * Math.cos(rad) + (double)x0 * Math.sin(rad)));
        return pivot.add(offset);
    }

    public Vec2f rotate(float rad) {
        return this.rotate(ZERO, rad);
    }

    public float lengthSqr() {
        return this.x * this.x + this.y * this.y;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSqr());
    }

    public float distanceSqr(Vec2f vec2f) {
        return this.subtract(vec2f).lengthSqr();
    }

    public float distance(Vec2f vec2f) {
        return (float)Math.sqrt(this.distanceSqr(vec2f));
    }

    public float getRotation() {
        float pi = (float)Math.PI;
        float len = this.length();
        if (len == 0.0f) {
            return 0.0f;
        }
        float asin = (float)Math.asin(this.y / len);
        if (this.x > 0.0f && this.y >= 0.0f) {
            return -asin;
        }
        if (this.x < 0.0f) {
            return pi + asin;
        }
        return 2.0f * pi - asin;
    }

    @Util
    public static Vec2f average(Vec2f ... vectors) {
        if (vectors.length < 1) {
            return ZERO;
        }
        if (vectors.length == 1) {
            return vectors[0];
        }
        Vec2f vec = ZERO;
        for (Vec2f v : vectors) {
            vec = vec.add(v);
        }
        return vec.scale(1.0f / (float)vectors.length);
    }

    @Util
    public static Vec2f sampling(Vec2f head, Vec2f tail, float percentage) {
        return head.add(tail.subtract(head).scale(percentage));
    }

    @Util
    public static float fastInvSqrt(float number) {
        return Mth.m_14195_((float)number);
    }

    @Util
    public static Vec2f intersection(Vec2f vec1Begin, Vec2f vec1End, Vec2f vec2Begin, Vec2f vec2End) {
        Vec2f direction1 = vec1End.subtract(vec1Begin).normal();
        Vec2f direction2 = vec2End.subtract(vec2Begin).normal();
        float t = vec2Begin.subtract(vec1Begin).cross(direction2) / direction1.cross(direction2);
        return vec1Begin.add(direction1.scale(t));
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vec2f)) {
            return false;
        }
        Vec2f vec2f = (Vec2f)obj;
        return vec2f.x == this.x && vec2f.y == this.y;
    }
}

