/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.config;

import java.util.HashMap;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class SimpleConfig {
    private final HashMap<String, ConfigContext<?>> values;
    private ForgeConfigSpec COMMON;
    private ForgeConfigSpec CLIENT;
    private ForgeConfigSpec SERVER;
    private final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    private final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    private final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    private boolean common_pushed = false;
    private boolean client_pushed = false;
    private boolean server_pushed = false;
    private ForgeConfigSpec.Builder cachedBuilder;

    public SimpleConfig() {
        this.values = new HashMap();
        this.cachedBuilder = this.COMMON_BUILDER;
    }

    public SimpleConfig client(String key) {
        this.popIfPushed();
        this.cachedBuilder = this.CLIENT_BUILDER;
        this.cachedBuilder.push(key);
        this.client_pushed = true;
        return this;
    }

    public SimpleConfig server(String key) {
        this.popIfPushed();
        this.cachedBuilder = this.SERVER_BUILDER;
        this.cachedBuilder.push(key);
        this.server_pushed = true;
        return this;
    }

    public SimpleConfig common(String key) {
        this.popIfPushed();
        this.cachedBuilder = this.COMMON_BUILDER;
        this.cachedBuilder.push(key);
        this.common_pushed = true;
        return this;
    }

    public SimpleConfig group(String key) {
        this.popIfPushed();
        this.cachedBuilder.push(key);
        if (this.cachedBuilder == this.COMMON_BUILDER) {
            this.common_pushed = true;
        } else if (this.cachedBuilder == this.CLIENT_BUILDER) {
            this.client_pushed = true;
        } else {
            this.server_pushed = true;
        }
        return this;
    }

    public SimpleConfig comment(String comment) {
        this.cachedBuilder.comment(comment);
        return this;
    }

    public SimpleConfig intConfig(String key, String comment, Integer defaultValue) {
        ForgeConfigSpec.ConfigValue value = this.cachedBuilder.comment(comment).define(key, (Object)defaultValue);
        this.values.put(key, new ConfigContext<Integer>(value, Integer.class, key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE));
        return this;
    }

    public SimpleConfig intConfig(String key, Integer defaultValue) {
        ForgeConfigSpec.ConfigValue value = this.cachedBuilder.define(key, (Object)defaultValue);
        this.values.put(key, new ConfigContext<Integer>(value, Integer.class, key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE));
        return this;
    }

    public SimpleConfig rangedIntConfig(String key, String comment, Integer defaultValue, Integer min, Integer max) {
        ForgeConfigSpec.IntValue value = this.cachedBuilder.comment(comment).defineInRange(key, defaultValue.intValue(), min.intValue(), max.intValue());
        this.values.put(key, new ConfigContext<Integer>((ForgeConfigSpec.ConfigValue<Integer>)value, Integer.class, key, defaultValue, min, max));
        return this;
    }

    public SimpleConfig rangedIntConfig(String key, Integer defaultValue, Integer min, Integer max) {
        ForgeConfigSpec.IntValue value = this.cachedBuilder.defineInRange(key, defaultValue.intValue(), min.intValue(), max.intValue());
        this.values.put(key, new ConfigContext<Integer>((ForgeConfigSpec.ConfigValue<Integer>)value, Integer.class, key, defaultValue, min, max));
        return this;
    }

    public SimpleConfig doubleConfig(String key, String comment, Double defaultValue) {
        ForgeConfigSpec.ConfigValue value = this.cachedBuilder.comment(comment).define(key, (Object)defaultValue);
        this.values.put(key, new ConfigContext<Double>((ForgeConfigSpec.ConfigValue<Double>)value, Double.class, key, defaultValue, (Double)Double.MIN_VALUE, (Double)Double.MAX_VALUE));
        return this;
    }

    public SimpleConfig doubleConfig(String key, Double defaultValue) {
        ForgeConfigSpec.ConfigValue value = this.cachedBuilder.define(key, (Object)defaultValue);
        this.values.put(key, new ConfigContext<Double>((ForgeConfigSpec.ConfigValue<Double>)value, Double.class, key, defaultValue, (Double)Double.MIN_VALUE, (Double)Double.MAX_VALUE));
        return this;
    }

    public SimpleConfig rangedDoubleConfig(String key, String comment, Double defaultValue, Double min, Double max) {
        ForgeConfigSpec.DoubleValue value = this.cachedBuilder.comment(comment).defineInRange(key, defaultValue.doubleValue(), min.doubleValue(), max.doubleValue());
        this.values.put(key, new ConfigContext<Double>((ForgeConfigSpec.ConfigValue<Double>)value, Double.class, key, defaultValue, min, max));
        return this;
    }

    public SimpleConfig rangedDoubleConfig(String key, Double defaultValue, Double min, Double max) {
        ForgeConfigSpec.DoubleValue value = this.cachedBuilder.defineInRange(key, defaultValue.doubleValue(), min.doubleValue(), max.doubleValue());
        this.values.put(key, new ConfigContext<Double>((ForgeConfigSpec.ConfigValue<Double>)value, Double.class, key, defaultValue, min, max));
        return this;
    }

    public SimpleConfig boolConfig(String key, String comment, Boolean defaultValue) {
        ForgeConfigSpec.ConfigValue value = this.cachedBuilder.comment(comment).define(key, (Object)defaultValue);
        this.values.put(key, new ConfigContext<Object>((ForgeConfigSpec.ConfigValue<Object>)value, (Class<Object>)Boolean.class, key, defaultValue, null, null));
        return this;
    }

    public <E extends Enum<?>> SimpleConfig enumConfig(String key, String comment, Class<E> clazz, E defaultValue) {
        ForgeConfigSpec.ConfigValue value = this.cachedBuilder.comment(comment).define(key, defaultValue);
        this.values.put(key, new ConfigContext<Object>((ForgeConfigSpec.ConfigValue<Object>)value, (Class<Object>)clazz, key, defaultValue, null, null));
        return this;
    }

    public <E extends Enum<?>> SimpleConfig enumConfig(String key, Class<E> clazz, E defaultValue) {
        ForgeConfigSpec.ConfigValue value = this.cachedBuilder.define(key, defaultValue);
        this.values.put(key, new ConfigContext<Object>((ForgeConfigSpec.ConfigValue<Object>)value, (Class<Object>)clazz, key, defaultValue, null, null));
        return this;
    }

    public SimpleConfig boolConfig(String key, Boolean defaultValue) {
        ForgeConfigSpec.ConfigValue value = this.cachedBuilder.define(key, (Object)defaultValue);
        this.values.put(key, new ConfigContext<Object>((ForgeConfigSpec.ConfigValue<Object>)value, (Class<Object>)Boolean.class, key, defaultValue, null, null));
        return this;
    }

    public SimpleConfig popCached() {
        this.popIfPushed();
        return this;
    }

    public SimpleConfig registerConfigs() {
        if (this.common_pushed) {
            this.COMMON_BUILDER.pop();
        }
        if (this.server_pushed) {
            this.SERVER_BUILDER.pop();
        }
        if (this.client_pushed) {
            this.CLIENT_BUILDER.pop();
        }
        this.common_pushed = false;
        this.server_pushed = false;
        this.client_pushed = false;
        this.COMMON = this.COMMON_BUILDER.build();
        this.CLIENT = this.CLIENT_BUILDER.build();
        this.SERVER = this.SERVER_BUILDER.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.COMMON);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.CLIENT);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)this.SERVER);
        return this;
    }

    public boolean contains(String key) {
        return this.values.containsKey(key);
    }

    public boolean contains(String key, Class<?> clazz) {
        return this.values.containsKey(key) && this.values.get((Object)key).clazz == clazz;
    }

    public boolean containsIntValue(String key) {
        return this.contains(key, Integer.class);
    }

    public boolean isRangedIntValue(String key) {
        if (!this.containsIntValue(key)) {
            return false;
        }
        return this.values.get((Object)key).value instanceof ForgeConfigSpec.IntValue;
    }

    public boolean containsDoubleValue(String key) {
        return this.contains(key, Double.class);
    }

    public boolean containsBoolValue(String key) {
        return this.contains(key, Boolean.class);
    }

    public boolean isRangedDoubleValue(String key) {
        if (!this.containsDoubleValue(key)) {
            return false;
        }
        return this.values.get((Object)key).value instanceof ForgeConfigSpec.DoubleValue;
    }

    public boolean containsEnum(String key) {
        return this.contains(key, Enum.class);
    }

    public Integer getIntValue(String key) {
        if (!this.containsIntValue(key)) {
            return 0;
        }
        return (Integer)this.values.get((Object)key).value.get();
    }

    public Boolean getBoolValue(String key) {
        if (!this.containsBoolValue(key)) {
            return false;
        }
        return (Boolean)this.values.get((Object)key).value.get();
    }

    public Double getDoubleValue(String key) {
        if (!this.containsDoubleValue(key)) {
            return 0.0;
        }
        return (Double)this.values.get((Object)key).value.get();
    }

    public <T extends Enum<?>> T getEnumValue(String key) {
        if (!this.containsEnum(key)) {
            return null;
        }
        return (T)((Enum)this.values.get((Object)key).value.get());
    }

    public Integer getDefaultInt(String key) {
        if (!this.containsIntValue(key)) {
            return 0;
        }
        return (Integer)this.values.get((Object)key).defaultValue;
    }

    public Double getDefaultDouble(String key) {
        if (!this.containsDoubleValue(key)) {
            return 0.0;
        }
        return (Double)this.values.get((Object)key).defaultValue;
    }

    public Boolean getDefaultBool(String key) {
        if (!this.containsBoolValue(key)) {
            return false;
        }
        return (Boolean)this.values.get((Object)key).defaultValue;
    }

    public <T extends Enum<?>> T getDefaultEnum(String key) {
        if (!this.containsEnum(key)) {
            return null;
        }
        return (T)((Enum)this.values.get((Object)key).defaultValue);
    }

    public Integer getMaxInt(String key) {
        if (!this.containsIntValue(key)) {
            return Integer.MAX_VALUE;
        }
        return (Integer)this.values.get((Object)key).max;
    }

    public Integer getMinInt(String key) {
        if (!this.containsIntValue(key)) {
            return Integer.MIN_VALUE;
        }
        return (Integer)this.values.get((Object)key).min;
    }

    public Double getMaxDouble(String key) {
        if (!this.containsDoubleValue(key)) {
            return Double.MAX_VALUE;
        }
        return (Double)this.values.get((Object)key).max;
    }

    public Double getMinDouble(String key) {
        if (!this.containsDoubleValue(key)) {
            return Double.MIN_VALUE;
        }
        return (Double)this.values.get((Object)key).min;
    }

    public ConfigContext<?> getContext(String key) {
        return this.values.getOrDefault(key, null);
    }

    private void popIfPushed() {
        if (this.cachedBuilder == this.COMMON_BUILDER && this.common_pushed) {
            this.cachedBuilder.pop();
            this.common_pushed = false;
        } else if (this.cachedBuilder == this.CLIENT_BUILDER && this.client_pushed) {
            this.cachedBuilder.pop();
            this.client_pushed = false;
        } else if (this.server_pushed) {
            this.cachedBuilder.pop();
            this.server_pushed = false;
        }
    }

    private record ConfigContext<T>(ForgeConfigSpec.ConfigValue<T> value, Class<T> clazz, String key, T defaultValue, T min, T max) {
    }
}

