/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.create.boundary;

import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kasuga.lib.core.create.boundary.CustomTrackSegmentPropagator;
import net.minecraft.nbt.CompoundTag;

public abstract class CustomBoundary
extends SingleBlockEntityEdgePoint {
    Map<Boolean, UUID> sidedSegements = new HashMap<Boolean, UUID>();
    Map<Boolean, Boolean> dirty = new HashMap<Boolean, Boolean>();

    protected CustomBoundary() {
        this.dirty.put(false, true);
        this.dirty.put(true, true);
    }

    public void onRemoved(TrackGraph graph) {
        super.onRemoved(graph);
        CustomTrackSegmentPropagator.onRemoved(graph, this);
    }

    public void setSegment(boolean direction, UUID segmentId) {
        this.sidedSegements.put(direction, segmentId);
    }

    public void setSegmentAndUpdate(boolean direction, UUID segmentId) {
        this.sidedSegements.put(direction, segmentId);
        this.dirty.put(direction, false);
    }

    public void markDirty(boolean direction) {
        this.dirty.put(direction, true);
    }

    public UUID getGroupId(boolean direction) {
        return this.sidedSegements.get(direction);
    }

    public void tick(TrackGraph graph, boolean preTrains) {
        for (boolean i : Iterate.trueAndFalse) {
            if (!this.shouldUpdate(i)) continue;
            this.dirty.put(i, false);
            CustomTrackSegmentPropagator.propagate(graph, this, i);
        }
    }

    public boolean shouldUpdate(boolean direction) {
        return this.dirty.get(direction);
    }

    public void write(CompoundTag nbt, DimensionPalette dimensions) {
        super.write(nbt, dimensions);
        for (boolean i : Iterate.trueAndFalse) {
            if (this.shouldUpdate(i)) {
                nbt.m_128379_("ShouldUpdate" + (i ? "Front" : "Back"), true);
            }
            nbt.m_128362_("SignalGroup" + (i ? "Front" : "Back"), this.sidedSegements.get(i));
        }
    }

    public void read(CompoundTag nbt, boolean migration, DimensionPalette dimensions) {
        super.read(nbt, migration, dimensions);
        for (boolean i : Iterate.trueAndFalse) {
            this.dirty.put(i, nbt.m_128471_("ShouldUpdate" + (i ? "Front" : "Back")));
            this.sidedSegements.put(i, nbt.m_128342_("SignalGroup" + (i ? "Front" : "Back")));
        }
    }

    public void clearDirty() {
        this.dirty.put(false, false);
        this.dirty.put(true, false);
    }
}

