/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.create.boundary;

import com.simibubi.create.Create;
import com.simibubi.create.content.trains.graph.EdgeData;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackGraphSync;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.create.boundary.BoundarySegmentRegistry;
import kasuga.lib.core.create.boundary.CustomBoundary;
import kasuga.lib.core.create.boundary.CustomTrackSegment;
import kasuga.lib.core.create.graph.EdgeExtraData;
import kasuga.lib.core.create.graph.GraphExtraData;
import kasuga.lib.core.create.graph.TrackEdgeLocation;
import kasuga.lib.core.util.data_type.Pair;
import net.minecraft.resources.ResourceLocation;

public class CustomTrackSegmentPropagator {
    public static void propagate(TrackGraph graph, CustomBoundary boundary, boolean direction) {
        UUID segmentId = UUID.randomUUID();
        CustomTrackSegment segment = BoundarySegmentRegistry.createSegment(boundary, segmentId);
        ResourceLocation featureName = BoundarySegmentRegistry.getFeatureName(boundary);
        GraphExtraData extraData = KasugaLib.STACKS.RAILWAY.get().withGraph(graph);
        TrackGraphSync sync = Create.RAILWAYS.sync;
        boundary.setSegment(direction, segmentId);
        CustomTrackSegmentPropagator.walk(graph, featureName, boundary, (EdgePointType<? super CustomBoundary>)boundary.getType(), direction, val -> {
            TrackNode node = (TrackNode)val.getFirst();
            CustomBoundary newBoundary = (CustomBoundary)((Object)((Object)val.getSecond()));
            UUID currentGroup = newBoundary.getGroupId(newBoundary.isPrimary(node));
            if (extraData.hasSegment(featureName, currentGroup)) {
                extraData.removeSegment(featureName, currentGroup);
            }
            newBoundary.setSegmentAndUpdate(newBoundary.isPrimary(node), segmentId);
            sync.pointAdded(graph, (TrackEdgePoint)newBoundary);
            return true;
        }, val -> {
            if (val.hasBoundaryFeature(featureName) && val.getBoundaryFeature(featureName) != EdgeExtraData.passiveBoundaryGroup) {
                extraData.removeSegment(featureName, val.getBoundaryFeature(featureName));
            }
            TrackEdgeLocation location = extraData.DEBUG_findLocationOf((EdgeExtraData)val);
            val.setBoundaryFeature(featureName, segmentId);
            return true;
        }, false);
        extraData.addSegment(featureName, segmentId, segment);
    }

    public static void notifyNewNode(TrackGraph graph, TrackNode node) {
        for (EdgePointType<? extends CustomBoundary> boundary : BoundarySegmentRegistry.getBoundaries()) {
            ArrayList<Couple<TrackNode>> frontier = new ArrayList<Couple<TrackNode>>();
            frontier.add(Couple.create((Object)node, (Object)null));
            ResourceLocation featureName = BoundarySegmentRegistry.getFeatureName(boundary);
            GraphExtraData extraData = KasugaLib.STACKS.RAILWAY.get().withGraph(graph);
            CustomTrackSegmentPropagator.walk(graph, featureName, frontier, boundary, pair -> {
                TrackNode node1 = (TrackNode)pair.getFirst();
                CustomBoundary customBoundaryInstance = (CustomBoundary)((Object)((Object)pair.getSecond()));
                customBoundaryInstance.markDirty(customBoundaryInstance.isPrimary(node1));
                return false;
            }, edge -> {
                if (!edge.hasCustomBoundaryInThisEdge(featureName)) {
                    edge.setBoundaryFeature(featureName, EdgeExtraData.passiveBoundaryGroup);
                    return true;
                }
                return false;
            }, false);
        }
    }

    public static void onRemoved(TrackGraph graph, CustomBoundary customBoundary) {
        ResourceLocation featureName = BoundarySegmentRegistry.getFeatureName(customBoundary);
        GraphExtraData extraData = KasugaLib.STACKS.RAILWAY.get().withGraph(graph);
        for (boolean front : Iterate.trueAndFalse) {
            if (customBoundary.shouldUpdate(front)) continue;
            CustomTrackSegmentPropagator.walk(graph, featureName, customBoundary, (EdgePointType<? super CustomBoundary>)customBoundary.getType(), front, boundaryPair -> {
                CustomBoundary boundary = (CustomBoundary)((Object)((Object)boundaryPair.getSecond()));
                TrackNode node = (TrackNode)boundaryPair.getFirst();
                boundary.markDirty(boundary.isPrimary(node));
                return false;
            }, edgeData -> {
                if (!edgeData.hasCustomBoundaryInThisEdge(featureName)) {
                    extraData.removeSegment(featureName, edgeData.getBoundaryFeature(featureName));
                    edgeData.setBoundaryFeature(featureName, EdgeExtraData.passiveBoundaryGroup);
                    return true;
                }
                return false;
            }, false);
        }
    }

    public static void walk(TrackGraph graph, ResourceLocation featureName, CustomBoundary boundary, EdgePointType<? super CustomBoundary> boundaryEdgePointType, boolean front, Predicate<Pair<TrackNode, ? super CustomBoundary>> boundaryCallback, Predicate<EdgeExtraData> nonBoundaryCallback, boolean forCollection) {
        CustomBoundary immediateBoundary;
        Couple edgeLocation = boundary.edgeLocation;
        Couple startNodes = edgeLocation.map(arg_0 -> ((TrackGraph)graph).locateNode(arg_0));
        Couple startEdges = startNodes.mapWithParams((l1, l2) -> (TrackEdge)graph.getConnectionsFrom(l1).get(l2), startNodes.swap());
        TrackNode node1 = (TrackNode)startNodes.get(front);
        TrackNode node2 = (TrackNode)startNodes.get(!front);
        TrackEdge startEdge = (TrackEdge)startEdges.get(front);
        TrackEdge oppositeEdge = (TrackEdge)startEdges.get(!front);
        if (startEdge == null) {
            return;
        }
        if (!forCollection) {
            KasugaLib.STACKS.RAILWAY.sync.edgeExtraDataChanged(graph, node1, node2, startEdge, oppositeEdge);
        }
        if ((immediateBoundary = (CustomBoundary)startEdge.getEdgeData().next(boundaryEdgePointType, boundary.getLocationOn(startEdge))) != null) {
            return;
        }
        ArrayList<Couple<TrackNode>> frontier = new ArrayList<Couple<TrackNode>>();
        frontier.add(Couple.create((Object)node2, (Object)node1));
        CustomTrackSegmentPropagator.walk(graph, featureName, frontier, boundaryEdgePointType, boundaryCallback, nonBoundaryCallback, forCollection);
    }

    private static void walk(TrackGraph graph, ResourceLocation featureName, List<Couple<TrackNode>> frontier, EdgePointType<? super CustomBoundary> boundaryEdgePointType, Predicate<Pair<TrackNode, ? super CustomBoundary>> circuitCallback, Predicate<EdgeExtraData> nonBoundaryCallback, boolean forCollection) {
        HashSet<TrackEdge> visited = new HashSet<TrackEdge>();
        GraphExtraData graphExtraData = KasugaLib.STACKS.RAILWAY.get().withGraph(graph);
        while (!frontier.isEmpty()) {
            Couple<TrackNode> couple = frontier.remove(0);
            TrackNode currentNode = (TrackNode)couple.getFirst();
            TrackNode prevNode = (TrackNode)couple.getSecond();
            block1: for (Map.Entry entry : graph.getConnectionsFrom(currentNode).entrySet()) {
                TrackNode nextNode = (TrackNode)entry.getKey();
                TrackEdge edge = (TrackEdge)entry.getValue();
                if (nextNode == prevNode || !visited.add(edge) || forCollection && !((TrackEdge)graph.getConnectionsFrom(prevNode).get(currentNode)).canTravelTo(edge)) continue;
                TrackEdge oppositeEdge = (TrackEdge)graph.getConnectionsFrom(nextNode).get(currentNode);
                visited.add(oppositeEdge);
                for (boolean flip : Iterate.falseAndTrue) {
                    TrackEdge currentEdge = flip ? oppositeEdge : edge;
                    EdgeData signalData = currentEdge.getEdgeData();
                    EdgeExtraData extraData = graphExtraData.getEdgeData(currentEdge);
                    if (!extraData.hasCustomBoundaryInThisEdge(featureName)) {
                        if (!nonBoundaryCallback.test(extraData)) continue;
                        KasugaLib.STACKS.RAILWAY.sync.edgeExtraDataChanged(graph, currentNode, nextNode, edge, oppositeEdge);
                        continue;
                    }
                    CustomBoundary nextBoundary = (CustomBoundary)signalData.next(boundaryEdgePointType, 0.0);
                    if (nextBoundary == null) continue;
                    if (!circuitCallback.test(Pair.of(currentNode, nextBoundary))) continue block1;
                    KasugaLib.STACKS.RAILWAY.sync.edgeExtraDataChanged(graph, currentNode, nextNode, edge, oppositeEdge);
                    continue block1;
                }
                frontier.add((Couple<TrackNode>)Couple.create((Object)nextNode, (Object)currentNode));
            }
        }
    }
}

