/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.create.device.behaviour;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.create.device.TrainDevice;
import kasuga.lib.core.create.device.TrainDeviceType;
import kasuga.lib.core.create.device.locator.InteractiveContext;
import kasuga.lib.core.create.graph.CarriageExtraData;
import net.minecraft.core.BlockPos;

public class MovingTrainDevice {
    public static void register(MovementContext context, TrainDeviceType type) {
        if (context.world.m_5776_()) {
            return;
        }
        AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return;
        }
        CarriageContraptionEntity carriageContraptionEntity = (CarriageContraptionEntity)abstractContraptionEntity;
        Carriage carriage = carriageContraptionEntity.getCarriage();
        CarriageExtraData extraData = KasugaLib.STACKS.RAILWAY.get().withTrainExtraData(carriage.train).getCarriage(carriage.train.carriages.indexOf(carriage));
        TrainDevice device = type.create(context);
        type.getLocatorType().create(context, type).register(device, extraData.getDeviceManager());
    }

    public static TrainDevice get(MovementContext context, TrainDeviceType type) {
        AbstractContraptionEntity abstractContraptionEntity;
        if (context.world.m_5776_()) {
            // empty if block
        }
        if (!((abstractContraptionEntity = context.contraption.entity) instanceof CarriageContraptionEntity)) {
            return null;
        }
        CarriageContraptionEntity carriageContraptionEntity = (CarriageContraptionEntity)abstractContraptionEntity;
        Carriage carriage = carriageContraptionEntity.getCarriage();
        CarriageExtraData extraData = KasugaLib.STACKS.RAILWAY.get().withTrainExtraData(carriage.train).getCarriage(carriage.train.carriages.indexOf(carriage));
        return type.getLocatorType().create(context, type).getDevice(extraData.getDeviceManager());
    }

    public static TrainDevice get(AbstractContraptionEntity contraptionEntity, BlockPos blockPos, TrainDeviceType type) {
        if (contraptionEntity instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity carriageContraptionEntity = (CarriageContraptionEntity)contraptionEntity;
            Contraption contraption = carriageContraptionEntity.getContraption();
            if (!(contraption instanceof CarriageContraption)) {
                return null;
            }
            CarriageContraption carriageContraption = (CarriageContraption)contraption;
            Carriage carriage = carriageContraptionEntity.getCarriage();
            CarriageExtraData extraData = KasugaLib.STACKS.RAILWAY.get().withTrainExtraData(carriage.train).getCarriage(carriage.train.carriages.indexOf(carriage));
            return type.getLocatorType().create(new InteractiveContext(carriage, carriageContraption, blockPos), type).getDevice(extraData.getDeviceManager());
        }
        return null;
    }
}

