/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.create.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kasuga.lib.core.create.boundary.ResourcePattle;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class EdgeExtraData {
    public static final UUID passiveBoundaryGroup = UUID.fromString("00000000-0000-0000-0000-000000000000");
    HashMap<ResourceLocation, UUID> customBoundaryGroups = new HashMap();

    public CompoundTag write(ResourcePattle resourcePattle) {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (Map.Entry<ResourceLocation, UUID> entry : this.customBoundaryGroups.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128405_("Id", resourcePattle.encode(entry.getKey()));
            if (entry.getValue() == null) {
                entryTag.m_128379_("NullValue", true);
            } else {
                entryTag.m_128362_("Value", entry.getValue());
            }
            listTag.add((Object)entryTag);
        }
        tag.m_128365_("BoundaryGroups", (Tag)listTag);
        return tag;
    }

    public void read(CompoundTag data, ResourcePattle resourcePattle) {
        ListTag tag = data.m_128437_("BoundaryGroups", 10);
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag entryTag = tag.m_128728_(i);
            UUID value = !entryTag.m_128471_("NullValue") ? entryTag.m_128342_("Value") : null;
            this.customBoundaryGroups.put(resourcePattle.decode(entryTag.m_128451_("Id")), value);
        }
    }

    public boolean hasBoundaryFeature(ResourceLocation featureName) {
        return !this.customBoundaryGroups.containsKey(featureName) || this.customBoundaryGroups.get(featureName) != null;
    }

    public boolean hasCustomBoundaryInThisEdge(ResourceLocation featureName) {
        return this.customBoundaryGroups.containsKey(featureName) && this.customBoundaryGroups.get(featureName) == null;
    }

    public void setBoundaryFeature(ResourceLocation featureName, UUID segmentId) {
        if (segmentId == passiveBoundaryGroup) {
            this.setBoundaryFeaturePassive(featureName);
            return;
        }
        this.customBoundaryGroups.put(featureName, segmentId);
    }

    public UUID getBoundaryFeature(ResourceLocation featureName) {
        return this.customBoundaryGroups.getOrDefault(featureName, passiveBoundaryGroup);
    }

    public void setBoundaryFeaturePassive(ResourceLocation featureName) {
        this.customBoundaryGroups.remove(featureName);
    }
}

