/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.create.graph;

import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import kasuga.lib.core.create.boundary.BoundarySegmentRegistry;
import kasuga.lib.core.create.boundary.CustomTrackSegment;
import kasuga.lib.core.create.boundary.ResourcePattle;
import kasuga.lib.core.create.graph.EdgeExtraData;
import kasuga.lib.core.create.graph.TrackEdgeLocation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;

public class GraphExtraData {
    HashMap<TrackEdgeLocation, EdgeExtraData> edgeExtraData = new HashMap();
    HashMap<ResourceLocation, HashMap<UUID, CustomTrackSegment>> segmentInstances = new HashMap();

    public void transfer(LevelAccessor level, TrackNode node, Map<TrackNode, TrackEdge> connections, GraphExtraData targetExtraData) {
        for (TrackEdge edge : connections.values()) {
            EdgeExtraData data = this.removeEdge(edge);
            targetExtraData.addEdge(edge, data);
        }
    }

    public TrackEdgeLocation DEBUG_findLocationOf(EdgeExtraData data) {
        for (Map.Entry<TrackEdgeLocation, EdgeExtraData> entry : this.edgeExtraData.entrySet()) {
            if (entry.getValue() != data) continue;
            return entry.getKey();
        }
        return null;
    }

    public void transferAll(GraphExtraData toOtherExtra) {
        this.edgeExtraData.forEach(toOtherExtra::addEdge);
        this.edgeExtraData.clear();
    }

    public void createEdge(TrackEdge edge) {
        this.edgeExtraData.put(TrackEdgeLocation.fromEdge(edge), new EdgeExtraData());
    }

    public void addEdge(TrackEdgeLocation edge, EdgeExtraData data) {
        this.edgeExtraData.put(edge, data);
    }

    public void addEdge(TrackEdge edge, EdgeExtraData data) {
        this.edgeExtraData.put(TrackEdgeLocation.fromEdge(edge), data);
    }

    public EdgeExtraData removeEdge(TrackEdge edge) {
        return this.edgeExtraData.remove(TrackEdgeLocation.fromEdge(edge));
    }

    public void syncWithExternal(Collection<TrackEdge> edges) {
        HashSet<TrackEdgeLocation> keySet = new HashSet<TrackEdgeLocation>(this.edgeExtraData.keySet());
        HashSet<TrackEdgeLocation> shouldAdd = new HashSet<TrackEdgeLocation>();
        for (TrackEdge edge : edges) {
            TrackEdgeLocation location = TrackEdgeLocation.fromEdge(edge);
            if (keySet.contains(location)) {
                keySet.remove(location);
                continue;
            }
            shouldAdd.add(location);
        }
        shouldAdd.forEach(l -> this.edgeExtraData.put((TrackEdgeLocation)l, new EdgeExtraData()));
        keySet.forEach(l -> this.edgeExtraData.remove(l));
    }

    public EdgeExtraData getEdgeData(TrackEdge edge) {
        return this.edgeExtraData.get(TrackEdgeLocation.fromEdge(edge));
    }

    public CompoundTag write(DimensionPalette dimensions, ResourcePattle resourcePattle) {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (Map.Entry<TrackEdgeLocation, EdgeExtraData> entry : this.edgeExtraData.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128365_("Location", (Tag)entry.getKey().write(dimensions));
            entryTag.m_128365_("Data", (Tag)entry.getValue().write(resourcePattle));
            listTag.add((Object)entryTag);
        }
        tag.m_128365_("EdgeExtraDatas", (Tag)listTag);
        ListTag segmentListTag = new ListTag();
        for (Map.Entry<ResourceLocation, HashMap<UUID, CustomTrackSegment>> entry : this.segmentInstances.entrySet()) {
            for (Map.Entry<UUID, CustomTrackSegment> segmentEntry : entry.getValue().entrySet()) {
                CompoundTag segmentTag = new CompoundTag();
                segmentTag.m_128362_("FeatureId", segmentEntry.getKey());
                segmentTag.m_128359_("FeatureName", entry.getKey().toString());
                segmentTag.m_128365_("Data", (Tag)segmentEntry.getValue().write());
                segmentListTag.add((Object)segmentTag);
            }
        }
        tag.m_128365_("Segments", (Tag)segmentListTag);
        return tag;
    }

    public void read(CompoundTag data, DimensionPalette dimensions, ResourcePattle resourcePattle) {
        ListTag listTag = data.m_128437_("EdgeExtraDatas", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag entryTag = listTag.m_128728_(i);
            TrackEdgeLocation edgeLocation = TrackEdgeLocation.read(entryTag.m_128469_("Location"), dimensions);
            EdgeExtraData extraData = this.edgeExtraData.computeIfAbsent(edgeLocation, x -> new EdgeExtraData());
            extraData.read(entryTag.m_128469_("Data"), resourcePattle);
        }
        ListTag segmentListTag = data.m_128437_("Segments", 10);
        for (int i = 0; i < segmentListTag.size(); ++i) {
            CompoundTag segmentTag = segmentListTag.m_128728_(i);
            ResourceLocation featureName = new ResourceLocation(segmentTag.m_128461_("FeatureName"));
            UUID featureId = segmentTag.m_128342_("FeatureId");
            CustomTrackSegment segment = BoundarySegmentRegistry.createSegmentByFeatureName(featureName, featureId);
            segment.read(segmentTag.m_128469_("Data"));
            this.addSegment(featureName, featureId, segment);
        }
    }

    public void addSegment(ResourceLocation featureName, UUID featureId, CustomTrackSegment segment) {
        this.segmentInstances.computeIfAbsent(featureName, i -> new HashMap()).put(featureId, segment);
    }

    public void removeSegment(ResourceLocation featureName, UUID featureId) {
        if (!this.segmentInstances.containsKey(featureName)) {
            return;
        }
        this.segmentInstances.get(featureName).remove(featureId);
    }

    public CustomTrackSegment getSegment(ResourceLocation featureName, UUID featureId) {
        if (!this.segmentInstances.containsKey(featureName)) {
            return null;
        }
        return this.segmentInstances.get(featureName).get(featureId);
    }

    public boolean hasSegment(ResourceLocation featureName, UUID featureId) {
        if (!this.segmentInstances.containsKey(featureName)) {
            return false;
        }
        return this.segmentInstances.get(featureName).containsKey(featureId);
    }
}

