/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.create.graph;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kasuga.lib.core.create.graph.GraphWalker;
import kasuga.lib.core.util.data_type.Couple;
import net.minecraft.world.phys.Vec3;

public class GraphSimplifier {
    public static int FLAG_IS_TURN = 0;

    public static SimplifiedSubGraph simpilify(TrackGraph graph) {
        TrackEdge beginerEdge = GraphSimplifier.findTrackWithoutBezier(graph);
        if (beginerEdge == null) {
            return new SimplifiedSubGraph();
        }
        ArrayList<Couple<TrackNode>> frontier = new ArrayList<Couple<TrackNode>>();
        frontier.add(new Couple<Object>(beginerEdge.node1, null));
        return GraphSimplifier.simpilify(graph, frontier, edge -> true);
    }

    public static SimplifiedSubGraph simpilify(TrackGraph graph, List<Couple<TrackNode>> frontier, Predicate<TrackEdge> edgeBoundaryPredicate) {
        SimplifiedSubGraph simplifiedGraph = new SimplifiedSubGraph();
        HashMap nodes = new HashMap();
        Predicate<TrackEdge> reader = edge -> {
            SimplifiedTrackVertex from = GraphSimplifier.getOrCreateVertex(simplifiedGraph, nodes, edge.node1);
            SimplifiedTrackVertex to = GraphSimplifier.getOrCreateVertex(simplifiedGraph, nodes, edge.node2);
            SimplifiedTrackEdge simplifiedEdge = new SimplifiedTrackEdge();
            simplifiedEdge.flags.set(FLAG_IS_TURN, edge.isTurn());
            from.addEdge(simplifiedEdge);
            to.addEdge(simplifiedEdge);
            simplifiedEdge.edges.add((TrackEdge)edge);
            simplifiedGraph.addEdge(simplifiedEdge);
            return edgeBoundaryPredicate.test((TrackEdge)edge);
        };
        GraphWalker.walk(graph, frontier, map -> map, reader);
        ArrayList<SimplifiedTrackVertex> shouldCleanup = new ArrayList<SimplifiedTrackVertex>();
        for (SimplifiedTrackVertex vertex : simplifiedGraph.vertices) {
            if (vertex.edges.size() != 2 || vertex.edges.stream().anyMatch(edge -> edge.flags.get(FLAG_IS_TURN))) continue;
            Iterator<SimplifiedTrackEdge> iterator = vertex.edges.iterator();
            SimplifiedTrackEdge left = iterator.next();
            SimplifiedTrackEdge right = iterator.next();
            vertex.removeEdge(left);
            vertex.removeEdge(right);
            shouldCleanup.add(vertex);
            SimplifiedTrackVertex nextVertex = right.getFirstAvailableVertex();
            nextVertex.removeEdge(right);
            nextVertex.addEdge(left);
            left.edges.addAll(right.edges);
            simplifiedGraph.removeEdge(right);
        }
        for (SimplifiedTrackVertex vertex : shouldCleanup) {
            simplifiedGraph.notifyCleanup(vertex);
        }
        return simplifiedGraph;
    }

    public static SimplifiedTrackVertex getOrCreateVertex(SimplifiedSubGraph graph, Map<TrackNode, SimplifiedTrackVertex> nodes, TrackNode node) {
        return nodes.computeIfAbsent(node, n -> {
            SimplifiedTrackVertex vertex = graph.createVertex((TrackNode)n);
            return vertex;
        });
    }

    public static TrackEdge findTrackWithoutBezier(TrackGraph graph) {
        for (TrackNodeLocation nodeLocation : graph.getNodes()) {
            TrackNode node = graph.locateNode(nodeLocation);
            if (node == null) continue;
            for (Map.Entry edgeEntry : graph.getConnectionsFrom(node).entrySet()) {
                TrackNode next = (TrackNode)edgeEntry.getKey();
                TrackEdge edge = (TrackEdge)edgeEntry.getValue();
                if (edge.isTurn()) continue;
                return edge;
            }
        }
        return null;
    }

    public static class SimplifiedSubGraph {
        Set<SimplifiedTrackVertex> vertices = new HashSet<SimplifiedTrackVertex>();
        Set<SimplifiedTrackEdge> edges = new HashSet<SimplifiedTrackEdge>();

        public SimplifiedTrackVertex createVertex(TrackNode node) {
            SimplifiedTrackVertex vertex = new SimplifiedTrackVertex(node);
            this.vertices.add(vertex);
            return vertex;
        }

        public void addEdge(SimplifiedTrackEdge edge) {
            this.edges.add(edge);
        }

        public boolean notifyCleanup(SimplifiedTrackVertex vertex) {
            boolean isEmptied = vertex.edges.isEmpty();
            if (isEmptied) {
                this.vertices.remove(vertex);
            }
            return isEmptied;
        }

        public JsonObject toJSON() {
            JsonObject json = new JsonObject();
            json.addProperty("type", "simplified");
            JsonArray verticesArray = new JsonArray();
            HashMap<SimplifiedTrackVertex, Integer> vertexTracker = new HashMap<SimplifiedTrackVertex, Integer>();
            int id = 0;
            for (SimplifiedTrackVertex vertex : this.vertices) {
                verticesArray.add((JsonElement)vertex.toJSON());
                vertexTracker.put(vertex, id++);
            }
            JsonArray edgesArray = new JsonArray();
            for (SimplifiedTrackEdge edge : this.edges) {
                edgesArray.add((JsonElement)edge.toJSON(vertexTracker));
            }
            json.add("vertices", (JsonElement)verticesArray);
            json.add("edges", (JsonElement)edgesArray);
            return json;
        }

        public void removeEdge(SimplifiedTrackEdge right) {
            this.edges.remove(right);
        }
    }

    public static class SimplifiedTrackVertex {
        private final TrackNode node;
        Set<SimplifiedTrackEdge> edges = new HashSet<SimplifiedTrackEdge>();

        SimplifiedTrackVertex(TrackNode node) {
            this.node = node;
        }

        public void addEdge(SimplifiedTrackEdge edge) {
            if (edge.vertices[0] == null) {
                edge.vertices[0] = this;
            } else if (edge.vertices[1] == null) {
                edge.vertices[1] = this;
            } else {
                throw new IllegalStateException("Edge already has two vertices");
            }
            this.edges.add(edge);
        }

        public void removeEdge(SimplifiedTrackEdge edge) {
            if (edge.vertices[0] == this) {
                edge.vertices[0] = null;
            } else if (edge.vertices[1] == this) {
                edge.vertices[1] = null;
            } else {
                throw new IllegalStateException("Edge does not contain this vertex");
            }
            this.edges.remove(edge);
        }

        public JsonObject toJSON() {
            JsonObject json = new JsonObject();
            Vec3 location = this.node.getLocation().getLocation();
            json.addProperty("x", (Number)location.m_7096_());
            json.addProperty("y", (Number)location.m_7098_());
            json.addProperty("z", (Number)location.m_7094_());
            return json;
        }
    }

    public static class SimplifiedTrackEdge {
        Set<TrackEdge> edges = new HashSet<TrackEdge>();
        SimplifiedTrackVertex[] vertices = new SimplifiedTrackVertex[2];
        BitSet flags = new BitSet();

        public SimplifiedTrackVertex getFirstAvailableVertex() {
            if (this.vertices[0] != null) {
                return this.vertices[0];
            }
            if (this.vertices[1] != null) {
                return this.vertices[1];
            }
            return null;
        }

        public JsonObject toJSON(HashMap<SimplifiedTrackVertex, Integer> vertexTracker) {
            JsonObject json = new JsonObject();
            json.addProperty("from", (Number)vertexTracker.get(this.vertices[0]));
            json.addProperty("to", (Number)vertexTracker.get(this.vertices[1]));
            json.addProperty("is_turn", Boolean.valueOf(this.flags.get(FLAG_IS_TURN)));
            return json;
        }
    }
}

