/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.create.graph;

import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import kasuga.lib.core.util.data_type.Couple;

public class GraphWalker {
    public static void walk(TrackGraph graph, List<Couple<TrackNode>> frontier, Function<Set<Map.Entry<TrackNode, TrackEdge>>, Collection<Map.Entry<TrackNode, TrackEdge>>> sortFunction, Predicate<TrackEdge> edgePredicate) {
        HashSet<TrackEdge> visited = new HashSet<TrackEdge>();
        while (!frontier.isEmpty()) {
            Couple<TrackNode> couple = frontier.remove(0);
            TrackNode currentNode = (TrackNode)couple.getFirst();
            TrackNode previousNode = (TrackNode)couple.getSecond();
            Map map = graph.getConnectionsFrom(currentNode);
            Collection<Map.Entry<TrackNode, TrackEdge>> sorted = sortFunction.apply(map.entrySet());
            for (Map.Entry<TrackNode, TrackEdge> entry : sorted) {
                TrackNode nextNode = entry.getKey();
                TrackEdge edge = entry.getValue();
                if (nextNode == previousNode || !visited.add(edge)) continue;
                TrackEdge oppositeEdge = (TrackEdge)graph.getConnectionsFrom(nextNode).get(currentNode);
                visited.add(oppositeEdge);
                if (!edgePredicate.test(edge)) continue;
                frontier.add(new Couple<TrackNode>(nextNode, currentNode));
            }
        }
    }
}

