/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.create.graph;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kasuga.lib.core.create.boundary.ResourcePattle;
import kasuga.lib.core.create.graph.GraphExtraData;
import kasuga.lib.core.create.graph.KasugaRailwayDataManager;
import kasuga.lib.core.create.graph.TrainExtraData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class RailwayData {
    private final KasugaRailwayDataManager manager;
    public HashMap<UUID, GraphExtraData> extraDatas = new HashMap();
    public HashMap<UUID, TrainExtraData> trainExtraDatas = new HashMap();

    RailwayData(KasugaRailwayDataManager manager) {
        this.manager = manager;
    }

    public void createExtraData(UUID graphId) {
        this.extraDatas.computeIfAbsent(graphId, id -> new GraphExtraData());
    }

    public void removeExtraData(UUID graphId) {
        this.extraDatas.remove(graphId);
    }

    public GraphExtraData withGraph(TrackGraph target) {
        if (this.extraDatas.containsKey(target.id)) {
            return this.extraDatas.get(target.id);
        }
        this.createExtraData(target.id);
        return this.extraDatas.get(target.id);
    }

    public void syncExtraData(Set<UUID> uuids) {
        HashSet<UUID> keySets = new HashSet<UUID>(this.extraDatas.keySet());
        HashSet<UUID> shouldAddSets = new HashSet<UUID>();
        for (UUID uuid : uuids) {
            if (keySets.contains(uuid)) {
                keySets.remove(uuid);
                continue;
            }
            shouldAddSets.add(uuid);
        }
        shouldAddSets.forEach(this::createExtraData);
        keySets.forEach(this::removeExtraData);
        this.markDirty();
    }

    public CompoundTag write(DimensionPalette dimensions, ResourcePattle resourcePattle) {
        CompoundTag tag = new CompoundTag();
        ListTag extraDataTags = new ListTag();
        for (Map.Entry<UUID, GraphExtraData> entry : this.extraDatas.entrySet()) {
            CompoundTag graphExtraDataTag = new CompoundTag();
            graphExtraDataTag.m_128362_("Id", entry.getKey());
            graphExtraDataTag.m_128365_("Data", (Tag)entry.getValue().write(dimensions, resourcePattle));
            extraDataTags.add((Object)graphExtraDataTag);
        }
        tag.m_128365_("ExtraDatas", (Tag)extraDataTags);
        return tag;
    }

    public void read(CompoundTag compoundTag, DimensionPalette dimensions, ResourcePattle resourcePattle) {
        this.markDirty();
        this.trainExtraDatas.clear();
        this.extraDatas.clear();
        ListTag extraDataTags = compoundTag.m_128437_("ExtraDatas", 10);
        for (int i = 0; i < extraDataTags.size(); ++i) {
            CompoundTag tag = extraDataTags.m_128728_(i);
            UUID id = tag.m_128342_("Id");
            GraphExtraData extraData = this.extraDatas.computeIfAbsent(id, x -> new GraphExtraData());
            extraData.read(tag.m_128469_("Data"), dimensions, resourcePattle);
        }
    }

    public void markDirty() {
        if (this.manager != null) {
            this.manager.m_77762_();
        }
    }

    public void putTrainExtraData(Train train) {
        if (this.trainExtraDatas.containsKey(train.id)) {
            return;
        }
        this.trainExtraDatas.put(train.id, new TrainExtraData(train));
    }

    public void removeTrainExtraData(UUID id) {
        this.trainExtraDatas.remove(id);
    }

    public TrainExtraData withTrainExtraData(Train train) {
        if (this.trainExtraDatas.containsKey(train.id)) {
            return this.trainExtraDatas.get(train.id);
        }
        this.putTrainExtraData(train);
        return this.trainExtraDatas.get(train.id);
    }

    public TrainExtraData withTrainExtraData(UUID id) {
        if (this.trainExtraDatas.containsKey(id)) {
            return this.trainExtraDatas.get(id);
        }
        return null;
    }
}

