/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.create.graph;

import com.simibubi.create.content.trains.entity.Train;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import kasuga.lib.core.KasugaLibClient;
import kasuga.lib.core.base.Saved;
import kasuga.lib.core.create.graph.KasugaRailwayDataManager;
import kasuga.lib.core.create.graph.RailwayData;
import kasuga.lib.core.create.graph.TrainDistanceIntegrator;
import kasuga.lib.core.create.graph.sync.RailwayDataSyncManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class RailwayManager {
    public RailwayDataSyncManager sync;
    protected Saved<KasugaRailwayDataManager> dataSaved;
    protected Map<Train, TrainDistanceIntegrator> integrators = Collections.synchronizedMap(new WeakHashMap());
    public RailwayData data;

    public static RailwayManager createServer() {
        return new RailwayManager(new Saved<SavedData>("kasuga_railway_data", () -> new KasugaRailwayDataManager(), KasugaRailwayDataManager::load));
    }

    public RailwayManager(Saved<KasugaRailwayDataManager> dataSaved) {
        this.dataSaved = dataSaved;
        this.sync = new RailwayDataSyncManager();
    }

    public RailwayManager(RailwayData data) {
        this.data = data;
    }

    public static RailwayManager createClient() {
        return new RailwayManager(new RailwayData(null));
    }

    public RailwayManager sided(boolean isClient) {
        if (isClient) {
            return (RailwayManager)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> KasugaLibClient.RAILWAY);
        }
        return this;
    }

    public RailwayManager sided(LevelAccessor accessor) {
        return this.sided(accessor.m_5776_());
    }

    public void load(ServerLevel level) {
        if (this.data == null && this.dataSaved != null) {
            this.data = this.dataSaved.loadFromDisk(level).getRailwayData();
        }
    }

    public void save(ServerLevel level) {
        if (this.dataSaved != null) {
            this.dataSaved.saveToDisk(level);
        }
    }

    public RailwayData get() {
        return this.data;
    }

    public TrainDistanceIntegrator getIntergartor(Train train) {
        return this.integrators.computeIfAbsent(train, i -> new TrainDistanceIntegrator());
    }
}

