/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import kasuga.lib.core.javascript.ContextModuleLoader;
import kasuga.lib.core.javascript.JavascriptThread;
import kasuga.lib.core.javascript.SideEffectContext;
import kasuga.lib.core.javascript.Tickable;
import kasuga.lib.core.javascript.engine.JavascriptEngineContext;
import kasuga.lib.core.javascript.engine.JavascriptModuleLoader;
import kasuga.lib.core.javascript.engine.JavascriptModuleScope;
import kasuga.lib.core.javascript.registration.RegistrationRegistry;
import kasuga.lib.core.util.Callback;

public class JavascriptContext {
    JavascriptThread thread;
    JavascriptEngineContext context;
    String name;
    SideEffectContext effect = new SideEffectContext();
    HashMap<String, Object> environment = new HashMap();
    ContextModuleLoader contextModuleLoader;
    Set<Tickable> tickables = new CopyOnWriteArraySet<Tickable>();

    JavascriptContext(String name, JavascriptThread thread) {
        this.thread = thread;
        this.name = name;
        String path = UUID.randomUUID().toString();
        this.contextModuleLoader = new ContextModuleLoader(thread.contextModuleLoader);
        this.context = thread.scriptEngine.createInstance(this);
        this.context.loadModule("@kasugalib/core");
    }

    public void close() {
        this.effect.close();
    }

    public void tick() {
        List<Tickable> tickables = List.copyOf(this.tickables);
        tickables.forEach(Tickable::tick);
        this.context.tick();
    }

    public Callback registerTickable(Tickable tickable) {
        if (this.tickables.contains(tickable)) {
            return Callback.nop();
        }
        return this.effect.effect(() -> {
            this.tickables.add(tickable);
            return () -> this.tickables.remove(tickable);
        });
    }

    public Callback collectEffect(Callback callback) {
        return this.effect.collect(callback);
    }

    public HashMap<String, Object> getEnvironment() {
        return this.environment;
    }

    public Callback runTask(Callback task) {
        Callback[] callback;
        callback = new Callback[]{this.effect.effect(() -> {
            Runnable finalTask = () -> {
                this.effect.remove(callback[0]);
                task.execute();
            };
            this.thread.recordCall(finalTask);
            return () -> this.thread.revokeCall(finalTask);
        })};
        return callback[0];
    }

    public JavascriptEngineContext getRuntimeContext() {
        return this.context;
    }

    public void loadModuleVoid(String name) {
        this.context.loadModule(name);
    }

    public JavascriptModuleScope getModuleScope() {
        return this.contextModuleLoader.getScope();
    }

    public JavascriptModuleLoader getModuleLoader() {
        return this.contextModuleLoader.getLoader();
    }

    public RegistrationRegistry getSidedRegistry() {
        return this.thread.sidedRegistry;
    }
}

