/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kasuga.lib.core.javascript.ContextModuleLoader;
import kasuga.lib.core.javascript.JavascriptContext;
import kasuga.lib.core.javascript.JavascriptThreadGroup;
import kasuga.lib.core.javascript.SynchronizedThread;
import kasuga.lib.core.javascript.engine.ScriptEngine;
import kasuga.lib.core.javascript.registration.RegistrationRegistry;

public class JavascriptThread
extends SynchronizedThread {
    private final JavascriptThreadGroup threadGroup;
    private final Map<Object, JavascriptContext> contexts = new HashMap<Object, JavascriptContext>();
    public ScriptEngine scriptEngine;
    public ContextModuleLoader contextModuleLoader;
    public RegistrationRegistry sidedRegistry;
    private Set<CompletableFuture> afterTerminate = new HashSet<CompletableFuture>();
    private Object target;

    public JavascriptThread(JavascriptThreadGroup javascriptThreadGroup, Object target, String description) {
        super("Javascript Thread - " + description);
        this.threadGroup = javascriptThreadGroup;
        this.scriptEngine = javascriptThreadGroup.getScriptEngine();
        this.contextModuleLoader = new ContextModuleLoader(javascriptThreadGroup.getModuleLoader());
        this.target = target;
        this.sidedRegistry = javascriptThreadGroup.getRegistry();
    }

    @Override
    protected void tick() {
        this.contexts.values().forEach(JavascriptContext::tick);
    }

    @Override
    protected void beforeStop() {
        this.contexts.values().forEach(JavascriptContext::close);
        this.threadGroup.onTerminate(this);
        this.afterTerminate.forEach(v -> v.complete(this));
    }

    public JavascriptContext createContext(Object target, String name) {
        return this.contexts.computeIfAbsent(target, o -> new JavascriptContext(name, this));
    }

    public void closeContext(Object obj) {
        JavascriptContext context = this.contexts.remove(obj);
        if (context != null) {
            context.close();
        }
    }

    public ContextModuleLoader getContextModuleLoader() {
        return this.contextModuleLoader;
    }

    public CompletableFuture<JavascriptThread> terminate() {
        CompletableFuture<JavascriptThread> future = new CompletableFuture<JavascriptThread>();
        if (!this.isAlive()) {
            future.complete(this);
            return future;
        }
        this.afterTerminate.add(future);
        this.shouldShutdown.set(true);
        this.threadGroup.terminate(this.target);
        return future;
    }
}

