/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kasuga.lib.core.javascript.ContextModuleLoader;
import kasuga.lib.core.javascript.JavascriptThread;
import kasuga.lib.core.javascript.engine.ScriptEngine;
import kasuga.lib.core.javascript.registration.RegistrationRegistry;

public class JavascriptThreadGroup {
    private final String name;
    Map<Object, JavascriptThread> threads = new HashMap<Object, JavascriptThread>();
    Set<JavascriptThread> terminating = new HashSet<JavascriptThread>();
    JavascriptThreadGroup parent;
    ThreadGroup threadGroup;
    Set<JavascriptThreadGroup> children = new HashSet<JavascriptThreadGroup>();
    ContextModuleLoader moduleLoader;
    private ScriptEngine scriptEngine;
    private RegistrationRegistry registry;

    public JavascriptThreadGroup(String name) {
        this.threadGroup = new ThreadGroup(name);
        this.parent = null;
        this.name = name;
        this.moduleLoader = new ContextModuleLoader();
    }

    public JavascriptThreadGroup(JavascriptThreadGroup parent, String name) {
        this.threadGroup = new ThreadGroup(parent.threadGroup, name);
        this.parent = parent;
        this.name = name;
        this.moduleLoader = new ContextModuleLoader(parent.moduleLoader);
    }

    public JavascriptThread getOrCreate(Object target, String description) {
        if (this.threads.containsKey(target)) {
            return this.threads.get(target);
        }
        JavascriptThread thread = new JavascriptThread(this, target, description);
        this.threads.put(target, thread);
        thread.start();
        return thread;
    }

    public void terminate() {
        for (JavascriptThread thread : this.threads.values()) {
            thread.shouldShutdown.set(true);
        }
        this.terminating.addAll(this.threads.values());
        this.threads.clear();
        this.threadGroup.interrupt();
    }

    public void terminate(Object target) {
        JavascriptThread thread = this.threads.get(target);
        if (thread != null) {
            thread.shouldShutdown.set(true);
            this.threads.remove(target);
            this.terminating.add(thread);
            thread.interrupt();
        }
        for (JavascriptThreadGroup child : this.children) {
            child.terminate(target);
        }
    }

    protected void onTerminate(JavascriptThread thread) {
        this.terminating.remove(thread);
    }

    public void dispatchTick() {
        for (JavascriptThread thread : this.threads.values()) {
            thread.dispatchTick();
        }
        for (JavascriptThreadGroup child : this.children) {
            child.dispatchTick();
        }
    }

    public JavascriptThreadGroup createChild(String name) {
        JavascriptThreadGroup threadGroup = new JavascriptThreadGroup(this, name);
        this.children.add(threadGroup);
        return threadGroup;
    }

    public ContextModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public JavascriptThread getThread(Object target) {
        return this.threads.get(target);
    }

    public RegistrationRegistry getRegistry() {
        if (this.registry == null && this.parent != null) {
            return this.parent.getRegistry();
        }
        return this.registry;
    }

    public void setRegistry(RegistrationRegistry registry) {
        this.registry = registry;
    }
}

