/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.engine.javet.converter;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.interop.converters.IJavetConverter;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kasuga.lib.core.javascript.engine.JavascriptValue;
import kasuga.lib.core.javascript.engine.annotations.HostAccess;
import kasuga.lib.core.javascript.engine.javet.JavetJavascriptValue;
import kasuga.lib.core.javascript.engine.javet.converter.FastJavetClassConverter;
import kasuga.lib.core.javascript.engine.javet.converter.MethodOverrideMap;
import kasuga.lib.core.javascript.engine.javet.converter.NativeProxyAccessor;

public class ClassAccessor {
    private final V8Runtime runtime;
    private final IJavetConverter provider;
    private final Class<?> classType;
    Map<String, Function<V8Value[], V8Value>> quickAccessors = new HashMap<String, Function<V8Value[], V8Value>>();
    Map<String, MethodOverrideMap> methods = new HashMap<String, MethodOverrideMap>();
    Map<String, Field> fields = new HashMap<String, Field>();
    boolean isFunctionalInterface = false;
    String functionalMethodName;

    public ClassAccessor(V8Runtime runtime, IJavetConverter provider, Class<?> classType) {
        this.runtime = runtime;
        this.provider = provider;
        this.classType = classType;
    }

    public Object invoke(Object target, String name, V8Value ... value) throws InvocationTargetException, IllegalAccessException, JavetException {
        if (this.quickAccessors.containsKey(name)) {
            return this.quickAccessors.get(name).apply(value);
        }
        if (!this.methods.containsKey(name)) {
            throw new RuntimeException("Illegal invocation");
        }
        MethodOverrideMap overrideMap = this.methods.get(name);
        int valueSize = value == null ? 0 : value.length;
        BitSet convertMask = overrideMap.converterMask.get(valueSize);
        List<Method> localMethods = overrideMap.methods.get(valueSize);
        if (convertMask == null || localMethods == null) {
            throw new RuntimeException("Illegal invocation");
        }
        Object[] arrayParameters = new Object[valueSize];
        for (int i = 0; i < valueSize; ++i) {
            Object nativeObject;
            arrayParameters[i] = !convertMask.get(i) ? new JavetJavascriptValue(value[i], this.runtime) : ((nativeObject = this.provider.toObject(value[i])) == null ? value[i] : nativeObject);
        }
        JavascriptValue[] values = new JavascriptValue[valueSize];
        for (int methodIndex = 0; methodIndex < localMethods.size(); ++methodIndex) {
            Method localMethod = localMethods.get(methodIndex);
            Class<?>[] parameterTypes = localMethod.getParameterTypes();
            Object[] parameters = new Object[valueSize];
            boolean isSignatureMatch = true;
            for (int parameterIndex = parameterTypes.length - 1; parameterIndex >= 0; --parameterIndex) {
                Class<?> parameterType = parameterTypes[parameterIndex];
                if (parameterType == JavascriptValue.class) {
                    if (values[parameterIndex] == null) {
                        values[parameterIndex] = new JavetJavascriptValue(value[parameterIndex], this.runtime);
                    }
                    parameters[parameterIndex] = values[parameterIndex];
                    continue;
                }
                Class<?> valueType = arrayParameters[parameterIndex].getClass();
                if (parameterType == valueType || parameterType.isAssignableFrom(valueType)) {
                    parameters[parameterIndex] = arrayParameters[parameterIndex];
                    continue;
                }
                isSignatureMatch = false;
                break;
            }
            if (!isSignatureMatch) continue;
            return localMethod.invoke(target, parameters);
        }
        throw new RuntimeException("Illegal invocation");
    }

    public Object get(Object object, String name) throws IllegalAccessException {
        return this.fields.get(name).get(object);
    }

    public Object set(Object object, String name, V8Value value) throws JavetException, IllegalAccessException {
        Object nativeObject = this.provider.toObject(value);
        if (!this.fields.get(name).getType().isAssignableFrom(nativeObject.getClass()) && !Modifier.isFinal(this.fields.get(name).getModifiers())) {
            throw new RuntimeException("Ileegal operation");
        }
        this.fields.get(name).set(object, nativeObject);
        return nativeObject;
    }

    public void addMethod(String name, Method method) {
        MethodOverrideMap overrideMap = this.methods.computeIfAbsent(name, i -> new MethodOverrideMap());
        overrideMap.initIfAbsent(method.getParameterCount());
        overrideMap.methods.get(method.getParameterCount()).add(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            if (parameterTypes[i2] != JavascriptValue.class) continue;
            overrideMap.converterMask.get(method.getParameterCount()).set(i2, false);
        }
        if (method.getReturnType() != Void.class) {
            overrideMap.isVoidReturn = false;
        }
    }

    public void addField(String name, Field field) {
        this.fields.put(name, field);
    }

    public static ClassAccessor collect(V8Runtime runtime, IJavetConverter converter, Class<?> classType) {
        Field[] fields;
        ClassAccessor accessor = new ClassAccessor(runtime, converter, classType);
        Method[] methods = classType.getMethods();
        HashSet<Method> filteredMethods = new HashSet<Method>();
        for (Method method : methods) {
            if (!method.isAnnotationPresent(HostAccess.Export.class)) continue;
            filteredMethods.add(method);
        }
        Class<?>[] interfaces = classType.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Method[] interfaceMethods;
            if (!interfaces[i].isAnnotationPresent(FunctionalInterface.class)) continue;
            Method[] methodArray = interfaceMethods = interfaces[i].getDeclaredMethods();
            int n = methodArray.length;
            for (int j = 0; j < n; ++j) {
                Method interfaceMethod = methodArray[j];
                for (Method method : methods) {
                    if (!Arrays.equals(method.getTypeParameters(), interfaceMethod.getTypeParameters()) || method.getReturnType() != interfaceMethod.getReturnType()) continue;
                    filteredMethods.add(method);
                    accessor.isFunctionalInterface = true;
                    accessor.functionalMethodName = method.getName();
                }
            }
        }
        for (Method filteredMethod : filteredMethods) {
            filteredMethod.setAccessible(true);
            accessor.addMethod(filteredMethod.getName(), filteredMethod);
        }
        for (Field field : fields = classType.getFields()) {
            if (!field.isAnnotationPresent(HostAccess.Export.class)) continue;
            accessor.addField(field.getName(), field);
        }
        return accessor;
    }

    public void bindPrototypeTo(V8Runtime runtime, FastJavetClassConverter converter, V8ValueObject value) throws JavetException {
        String name;
        for (Map.Entry<String, MethodOverrideMap> entry : this.methods.entrySet()) {
            name = entry.getKey();
            MethodOverrideMap overrideMap = entry.getValue();
            this.bind(runtime, value, converter, name, overrideMap.isVoidReturn);
        }
        for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
            name = entry.getKey();
            Field field = (Field)entry.getValue();
            this.bindProp(runtime, value, converter, name, Modifier.isFinal(field.getModifiers()));
        }
    }

    protected void bind(V8Runtime runtime, V8ValueObject value, FastJavetClassConverter converter, String name, boolean voidReturn) throws JavetException {
        System.out.printf("BIND RUNTIME: %s \n", name);
        JavetCallbackContext context = NativeProxyAccessor.getCallbackContext(runtime, converter, this, this.classType, name, voidReturn ? NativeProxyAccessor.AccessorType.METHOD_VOID : NativeProxyAccessor.AccessorType.METHOD);
        value.bindFunction(context);
    }

    protected void bindProp(V8Runtime runtime, V8ValueObject value, FastJavetClassConverter converter, String name, boolean isReadOnly) throws JavetException {
        System.out.printf("BIND RUNTIME: %s \n", name);
        JavetCallbackContext readContext = NativeProxyAccessor.getCallbackContext(runtime, converter, this, this.classType, name, NativeProxyAccessor.AccessorType.FIELD_READ);
        if (isReadOnly) {
            value.bindProperty(readContext);
            return;
        }
        JavetCallbackContext writeContext = NativeProxyAccessor.getCallbackContext(runtime, converter, this, this.classType, name, NativeProxyAccessor.AccessorType.FIELD_WRITE);
        value.bindProperty(readContext, writeContext);
    }

    public V8ValueObject createObject(Object object, IJavetConverter converter, V8Runtime v8Runtime) throws JavetException {
        if (this.isFunctionalInterface) {
            return v8Runtime.createV8ValueFunction(new JavetCallbackContext("apply", JavetCallbackType.DirectCallNoThisAndResult, values -> converter.toV8Value(v8Runtime, this.invoke(object, this.functionalMethodName, values))));
        }
        return v8Runtime.createV8ValueObject();
    }
}

