/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.engine.javet.converter;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.interop.converters.JavetObjectConverter;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.HashMap;
import kasuga.lib.core.javascript.engine.javet.JavetJavascriptValue;
import kasuga.lib.core.javascript.engine.javet.JavetValue;
import kasuga.lib.core.javascript.engine.javet.converter.ClassAccessor;

public class FastJavetClassConverter
extends JavetObjectConverter {
    private final V8Runtime v8Runtime;
    private final V8ValueSymbol tracker;
    private final V8ValueFunction setPrototypeOf;
    public HashMap<Class, V8ValueObject> classTypeCache = new HashMap();
    public HashMap<Class, ClassAccessor> accessors = new HashMap();
    HashMap<Integer, WeakReference<Object>> cachedObjects = new HashMap();
    HashMap<Long, Integer> trackingObjects = new HashMap();

    public FastJavetClassConverter(V8Runtime v8Runtime) {
        this.v8Runtime = v8Runtime;
        try {
            this.tracker = v8Runtime.createV8ValueSymbol("GC Tracker");
            this.setPrototypeOf = (V8ValueFunction)((V8ValueObject)v8Runtime.getGlobalObject().getProperty("Object")).getProperty("setPrototypeOf");
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    public V8ValueObject getClassPrototype(Class<?> prototype) throws JavetException {
        if (this.classTypeCache.containsKey(prototype)) {
            return this.classTypeCache.get(prototype);
        }
        V8ValueObject prototypeObject = this.v8Runtime.createV8ValueObject();
        ClassAccessor accessor = ClassAccessor.collect(this.v8Runtime, this, prototype);
        this.accessors.put(prototype, accessor);
        accessor.bindPrototypeTo(this.v8Runtime, this, prototypeObject);
        this.classTypeCache.put(prototype, prototypeObject);
        return prototypeObject;
    }

    @Override
    protected <T extends V8Value> T toV8Value(V8Runtime v8Runtime, Object object, int depth) throws JavetException {
        if (object == null) {
            return (T)v8Runtime.createV8ValueNull();
        }
        if (object instanceof JavetJavascriptValue) {
            JavetJavascriptValue value2 = (JavetJavascriptValue)object;
            return value2.getValue().toClone();
        }
        if (object instanceof V8Value) {
            V8Value value3 = (V8Value)object;
            return value3.toClone();
        }
        if (object instanceof int[] || object instanceof float[] || object instanceof double[] || object instanceof long[] || object instanceof short[] || object instanceof byte[] || object instanceof String || object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Character || object instanceof BigInteger) {
            return super.toV8Value(v8Runtime, object, depth);
        }
        Object v8Value = super.toV8Value(v8Runtime, object, depth);
        if (v8Value != null && !v8Value.isUndefined()) {
            if (v8Value instanceof V8ValueObject) {
                V8ValueObject v8ValueObject = (V8ValueObject)v8Value;
                int hashCode = System.identityHashCode(object);
                this.cachedObjects.put(hashCode, new WeakReference<Object>(object));
                v8ValueObject.setPrivateProperty("KasugaLib#Address", hashCode);
                v8ValueObject.bindFunction(new JavetCallbackContext("__nGCTracker__", JavetCallbackType.DirectCallThisAndResult, value -> this.toV8Value(v8Runtime, object)));
                v8ValueObject.setWeak();
            }
            return v8Value;
        }
        V8ValueObject proto = this.getClassPrototype(object.getClass());
        V8ValueObject childObject = this.accessors.get(object.getClass()).createObject(object, this, v8Runtime);
        int hashCode = System.identityHashCode(object);
        this.cachedObjects.put(hashCode, new WeakReference<Object>(object));
        childObject.setPrivateProperty("KasugaLib#Address", hashCode);
        childObject.bindFunction(new JavetCallbackContext("__nGCTracker__", JavetCallbackType.DirectCallThisAndResult, value -> this.toV8Value(v8Runtime, object)));
        childObject.set((Object)"__proto__", (Object)proto);
        childObject.setWeak();
        return (T)childObject;
    }

    @Override
    protected <T> T toObject(V8Value v8Value, int depth) throws JavetException {
        int address;
        V8ValueObject object;
        if (v8Value instanceof V8ValueObject && (object = (V8ValueObject)v8Value).hasPrivateProperty("KasugaLib#Address") && this.cachedObjects.containsKey(address = object.getPrivatePropertyInteger("KasugaLib#Address").intValue())) {
            Object nativeObject = this.cachedObjects.get(address).get();
            return nativeObject;
        }
        Object parentConvertResult = super.toObject(v8Value, depth);
        if (parentConvertResult instanceof V8Value) {
            return (T)new JavetJavascriptValue(JavetValue.weakClone(v8Value), v8Value.getV8Runtime());
        }
        return parentConvertResult;
    }

    public Object getNativeObject(V8ValueObject object) throws JavetException {
        Object idObj = object.getPrivatePropertyPrimitive("KasugaLib#Address");
        if (!(idObj instanceof Integer)) {
            throw new RuntimeException("Invalid Innvocation");
        }
        Integer id = (Integer)idObj;
        return this.cachedObjects.get(id).get();
    }
}

