/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.engine.javet.converter;

import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.values.reference.V8ValueObject;
import kasuga.lib.core.javascript.engine.javet.converter.ClassAccessor;
import kasuga.lib.core.javascript.engine.javet.converter.FastJavetClassConverter;

public class NativeProxyAccessor {
    public static JavetCallbackContext getCallbackContext(V8Runtime runtime, FastJavetClassConverter converter, ClassAccessor accessor, Class<?> className, String name, AccessorType type) {
        return switch (type) {
            case AccessorType.METHOD -> new JavetCallbackContext(name, JavetCallbackType.DirectCallThisAndResult, (_this, args) -> {
                if (!(_this instanceof V8ValueObject)) {
                    throw new RuntimeException("Illegal invocation");
                }
                V8ValueObject object = (V8ValueObject)_this;
                Object targetObject = converter.getNativeObject(object);
                if (targetObject == null) {
                    throw new RuntimeException("Illegal invocation");
                }
                if (!className.isAssignableFrom(targetObject.getClass())) {
                    throw new RuntimeException("Illegal invocation: " + className.getName() + "/" + targetObject.getClass().getName());
                }
                return converter.toV8Value(runtime, accessor.invoke(targetObject, name, args));
            });
            case AccessorType.METHOD_VOID -> new JavetCallbackContext(name, JavetCallbackType.DirectCallThisAndNoResult, (_this, args) -> {
                if (!(_this instanceof V8ValueObject)) {
                    throw new RuntimeException("Illegal invocation");
                }
                V8ValueObject object = (V8ValueObject)_this;
                Object targetObject = converter.getNativeObject(object);
                if (targetObject == null) {
                    throw new RuntimeException("Illegal invocation");
                }
                if (!className.isAssignableFrom(targetObject.getClass())) {
                    throw new RuntimeException("Illegal invocation");
                }
                accessor.invoke(targetObject, name, args);
            });
            case AccessorType.FIELD_READ -> new JavetCallbackContext(name, JavetCallbackType.DirectCallGetterAndThis, _this -> {
                if (!(_this instanceof V8ValueObject)) {
                    throw new RuntimeException("Illegal invocation");
                }
                V8ValueObject object = (V8ValueObject)_this;
                Object targetObject = converter.getNativeObject(object);
                if (targetObject == null) {
                    throw new RuntimeException("Illegal invocation");
                }
                if (!className.isAssignableFrom(targetObject.getClass())) {
                    throw new RuntimeException("Illegal invocation");
                }
                return converter.toV8Value(runtime, accessor.get(targetObject, name));
            });
            case AccessorType.FIELD_WRITE -> new JavetCallbackContext(name, JavetCallbackType.DirectCallSetterAndThis, (_this, value) -> {
                if (!(_this instanceof V8ValueObject)) {
                    throw new RuntimeException("Illegal invocation");
                }
                V8ValueObject object = (V8ValueObject)_this;
                Object targetObject = converter.getNativeObject(object);
                if (targetObject == null) {
                    throw new RuntimeException("Illegal invocation");
                }
                if (!className.isAssignableFrom(targetObject.getClass())) {
                    throw new RuntimeException("Illegal invocation");
                }
                return converter.toV8Value(runtime, accessor.set(targetObject, name, value));
            });
            default -> throw new UnsupportedOperationException();
        };
    }

    public static enum AccessorType {
        FIELD_READ,
        FIELD_WRITE,
        METHOD,
        METHOD_VOID;

    }
}

