/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.prebuilt.timer;

import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class KasugaTimer {
    public final PriorityQueue<CallbackEntry> queue = new PriorityQueue();
    public final HashMap<Integer, CallbackEntry> queryMap = new HashMap();
    private final AtomicInteger counter = new AtomicInteger(1);
    private long ticksCounter = 0L;

    public void onTick() {
        ++this.ticksCounter;
        while (!this.queue.isEmpty() && this.queue.peek().nextTicks <= this.ticksCounter) {
            CallbackEntry entry = this.queue.poll();
            if (entry.type == TimerType.INTERVAL) {
                entry.nextTicks = this.ticksCounter + Math.max(entry.durations, 1L);
                this.queue.add(entry);
            } else {
                this.queryMap.remove(entry.id);
            }
            entry.callback.tick();
        }
    }

    public int register(TimerType type, Callback callback, int ticks) {
        int id = this.counter.incrementAndGet();
        this.wanted(new CallbackEntry(id, type, callback, ticks, this.ticksCounter + (long)ticks));
        return id;
    }

    public void unregister(int id) {
        CallbackEntry entry = this.queryMap.get(id);
        this.queue.remove(entry);
    }

    protected void wanted(CallbackEntry entry) {
        this.queryMap.put(entry.id, entry);
        this.queue.add(entry);
    }

    public void close() {
        this.queue.clear();
    }

    public static class CallbackEntry
    implements Comparable<CallbackEntry> {
        final int id;
        final TimerType type;
        final Callback callback;
        long nextTicks;
        long durations;

        CallbackEntry(int timerId, TimerType type, Callback callback, long durations, long ticks) {
            this.id = timerId;
            this.type = type;
            this.callback = callback;
            this.durations = durations;
            this.nextTicks = ticks;
        }

        @Override
        public int compareTo(@NotNull CallbackEntry target) {
            return Long.compare(this.nextTicks, target.nextTicks);
        }
    }

    public static enum TimerType {
        TIMEOUT,
        INTERVAL;

    }

    @FunctionalInterface
    public static interface Callback {
        public void tick();
    }
}

