/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.prebuilt.websocket;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import kasuga.lib.core.javascript.JavascriptContext;
import kasuga.lib.core.javascript.engine.JavascriptValue;
import kasuga.lib.core.javascript.engine.annotations.HostAccess;
import kasuga.lib.core.javascript.prebuilt.PrebuiltModule;
import kasuga.lib.core.javascript.prebuilt.websocket.WebsocketInterface;

public class WebSocketPrebuiltModule
extends PrebuiltModule {
    protected Set<WeakReference<WebsocketInterface>> wsReferences = new HashSet<WeakReference<WebsocketInterface>>();

    public WebSocketPrebuiltModule(JavascriptContext runtime) {
        super(runtime);
    }

    @HostAccess.Export
    public WebsocketInterface createWebSocket(JavascriptValue url) {
        if (!url.isString()) {
            throw new IllegalArgumentException("Invalid URL");
        }
        WebsocketInterface websocketInterface = new WebsocketInterface(url.asString());
        this.wsReferences.add(new WeakReference<WebsocketInterface>(websocketInterface));
        return websocketInterface;
    }

    @Override
    public void tick() {
        HashSet<WeakReference<WebsocketInterface>> shouldClean = new HashSet<WeakReference<WebsocketInterface>>();
        for (WeakReference<WebsocketInterface> wsReference : this.wsReferences) {
            WebsocketInterface websocketInterface = (WebsocketInterface)wsReference.get();
            if (websocketInterface != null) {
                websocketInterface.tick();
                continue;
            }
            shouldClean.add(wsReference);
        }
        this.wsReferences.removeAll(shouldClean);
    }

    @Override
    public void close() {
        for (WeakReference<WebsocketInterface> wsReference : this.wsReferences) {
            WebsocketInterface wsi = (WebsocketInterface)wsReference.get();
            if (wsi == null) continue;
            wsi.close();
        }
    }

    @Override
    protected boolean isTickable() {
        return true;
    }
}

