/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.KasugaLibStacks;
import kasuga.lib.core.menu.base.GuiMenu;
import kasuga.lib.core.menu.base.GuiMenuRegistry;
import kasuga.lib.core.menu.javascript.JavascriptMenuRegistry;
import kasuga.lib.core.menu.locator.LocatedMenuManager;
import kasuga.lib.core.menu.locator.MenuLocator;
import kasuga.lib.core.menu.locator.MenuLocatorRegistry;
import kasuga.lib.core.menu.locator.MenuLocatorTypes;
import kasuga.lib.core.menu.network.GuiMenuNetworking;
import kasuga.lib.core.menu.targets.TargetsClient;

public class GuiMenuManager {
    GuiMenuRegistry registry = new GuiMenuRegistry();
    JavascriptMenuRegistry javascriptRegistry = new JavascriptMenuRegistry();
    MenuLocatorRegistry locatorRegistry = new MenuLocatorRegistry();
    HashMap<MenuLocator, List<UUID>> serverKnownData = new HashMap();
    HashMap<MenuLocator, List<UUID>> clientKnownData = new HashMap();
    Map<MenuLocator, LocatedMenuManager> clientLocators = new HashMap<MenuLocator, LocatedMenuManager>();
    Map<MenuLocator, LocatedMenuManager> serverLocators = new HashMap<MenuLocator, LocatedMenuManager>();
    protected List<GuiMenu> tickables = new ArrayList<GuiMenu>();

    public void init() {
        GuiMenuNetworking.invoke();
        this.locatorRegistry.register(KasugaLibStacks.REGISTRY.asResource("block"), MenuLocatorTypes.BLOCK);
        this.locatorRegistry.register(KasugaLibStacks.REGISTRY.asResource("entity"), MenuLocatorTypes.ENTITY);
        this.locatorRegistry.register(KasugaLibStacks.REGISTRY.asResource("contraption"), MenuLocatorTypes.CONTRAPTION);
    }

    public void initClient() {
        TargetsClient.register();
    }

    public void initRegistry() {
        KasugaLib.STACKS.JAVASCRIPT.SERVER_REGISTRY.register(KasugaLibStacks.REGISTRY.asResource("menu"), this.javascriptRegistry);
    }

    public void addClientLocator(MenuLocator locator, LocatedMenuManager manager) {
        if (this.clientLocators.containsKey(locator)) {
            this.removeClientLocator(locator);
        }
        this.clientLocators.put(locator, manager);
        if (this.clientKnownData.containsKey(locator)) {
            manager.asClient(List.copyOf((Collection)this.clientKnownData.get(locator)));
        }
    }

    public void removeClientLocator(MenuLocator locator) {
        LocatedMenuManager manager = this.clientLocators.remove(locator);
        if (manager != null) {
            manager.close();
        }
    }

    public void addServerLocator(MenuLocator locator, LocatedMenuManager manager) {
        if (this.serverLocators.containsKey(locator) && this.serverLocators.get(locator) != manager) {
            this.removeServerLocator(locator);
        }
        this.serverLocators.put(locator, manager);
        this.serverKnownData.put(locator, manager.asServer());
        locator.enable(manager);
    }

    public void removeServerLocator(MenuLocator locator) {
        if (this.serverLocators.containsKey(locator)) {
            LocatedMenuManager manager = this.serverLocators.remove(locator);
            locator.disable(manager);
            manager.close();
        }
        if (this.serverKnownData.containsKey(locator)) {
            this.serverKnownData.remove(locator);
        }
    }

    public MenuLocatorRegistry getLocatorRegistry() {
        return this.locatorRegistry;
    }

    public void notifyMenuChange(MenuLocator locator, List<UUID> knownData) {
        if (knownData.size() != 0) {
            this.clientKnownData.put(locator, knownData);
            if (this.clientLocators.containsKey(locator)) {
                this.clientLocators.get(locator).asClient(List.copyOf(knownData));
            }
        } else {
            this.clientKnownData.remove(locator);
            this.removeClientLocator(locator);
        }
    }

    public JavascriptMenuRegistry getJavascriptRegistry() {
        return this.javascriptRegistry;
    }

    public void addMenuTickInstance(GuiMenu guiMenu) {
        this.tickables.add(guiMenu);
    }

    public void removeMenuTickInstance(GuiMenu guiMenu) {
        this.tickables.remove(guiMenu);
    }

    public void clientTick() {
        for (GuiMenu menu : this.tickables) {
            menu.clientTick();
        }
    }

    public void reset() {
        List<GuiMenu> menus = List.copyOf(this.tickables);
        for (GuiMenu menu : menus) {
            menu.close();
        }
        this.tickables.clear();
    }
}

