/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.api;

import java.util.Objects;
import java.util.WeakHashMap;
import kasuga.lib.core.channel.peer.ChannelHandle;
import kasuga.lib.core.javascript.CompoundTagWrapper;
import kasuga.lib.core.javascript.engine.annotations.HostAccess;

public class ChannelHandlerProxy {
    private static final WeakHashMap<ChannelHandle, ChannelHandlerProxy> CACHE = new WeakHashMap();
    private final ChannelHandle channel;

    private ChannelHandlerProxy(ChannelHandle channel) {
        this.channel = channel;
    }

    public static ChannelHandlerProxy wrap(ChannelHandle channel) {
        return CACHE.computeIfAbsent(channel, ChannelHandlerProxy::new);
    }

    @HostAccess.Export
    public void sendMessage(CompoundTagWrapper message) {
        this.channel.sendMessage(message.getNativeTag());
    }

    @HostAccess.Export
    public void close() {
        this.channel.close();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChannelHandlerProxy)) {
            return false;
        }
        ChannelHandlerProxy that = (ChannelHandlerProxy)object;
        return Objects.equals(this.channel, that.channel);
    }

    public int hashCode() {
        return Objects.hash(this.channel);
    }
}

