/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.api;

import java.util.Objects;
import java.util.WeakHashMap;
import kasuga.lib.core.channel.address.ConnectionInfo;
import kasuga.lib.core.channel.peer.Channel;
import kasuga.lib.core.javascript.engine.annotations.HostAccess;
import kasuga.lib.core.util.data_type.Pair;

public class ChannelProxy {
    private static final WeakHashMap<Pair<Channel, Boolean>, ChannelProxy> CACHE = new WeakHashMap();
    private final Channel channel;
    private final boolean isClient;

    private ChannelProxy(Channel channel, boolean isClient) {
        this.channel = channel;
        this.isClient = isClient;
    }

    public static ChannelProxy wrap(Channel channel, boolean isClient) {
        return CACHE.computeIfAbsent(Pair.of(channel, isClient), c -> new ChannelProxy((Channel)c.getFirst(), (Boolean)c.getSecond()));
    }

    @HostAccess.Export
    public ConnectionInfo source() {
        return this.isClient ? this.channel.destination() : this.channel.source();
    }

    @HostAccess.Export
    public ConnectionInfo destination() {
        return this.isClient ? this.channel.source() : this.channel.destination();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ChannelProxy that = (ChannelProxy)object;
        return this.isClient == that.isClient && Objects.equals(this.channel, that.channel);
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.isClient);
    }
}

