/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.base;

import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.frontend.common.event.Event;
import kasuga.lib.core.client.frontend.gui.GuiInstance;
import kasuga.lib.core.menu.api.GuiMenuOperateProxy;
import kasuga.lib.core.menu.base.GuiBindingTarget;
import kasuga.lib.core.menu.base.GuiMenu;
import kasuga.lib.core.util.Envs;
import net.minecraft.resources.ResourceLocation;

public class BindingClient {
    public static HashMap<GuiBindingTarget<?>, Function<GuiInstance, ?>> bindings = new HashMap();

    public static <U> U applyBinding(GuiBindingTarget<U> binding, UUID targetUUID) {
        if (Envs.isClient()) {
            Optional<GuiInstance> instance = KasugaLib.STACKS.GUI.orElseThrow().getInstanceById(targetUUID);
            if (instance.isPresent()) {
                return BindingClient.getBindingTarget(binding).apply(instance.get());
            }
            System.out.println("[Warning] Screen is Null");
        }
        System.out.println("[Warning] Return value is null");
        return null;
    }

    public static <U> Function<GuiInstance, U> getBindingTarget(GuiBindingTarget<U> binding) {
        return bindings.get(binding);
    }

    public static <U> void registerBinding(GuiBindingTarget<U> binding, Function<GuiInstance, U> executor) {
        bindings.put(binding, executor);
    }

    public static void createInstance(GuiMenu guiMenu, UUID id, ResourceLocation location) {
        GuiInstance instance = KasugaLib.STACKS.GUI.orElseThrow().create(id, location);
        instance.putContextObject("menu", GuiMenuOperateProxy.wrap(guiMenu));
    }

    public static void dispatchGuiEvent(UUID id, Event event) {
        KasugaLib.STACKS.GUI.orElseThrow().getInstanceById(id).ifPresent(instance -> instance.getContext().ifPresent(c -> c.appendTask(() -> c.dispatchEvent(event.getType(), event))));
    }

    public static void closeInstance(UUID id) {
        KasugaLib.STACKS.GUI.orElseThrow().getInstanceById(id).ifPresent(instance -> KasugaLib.STACKS.GUI.orElseThrow().closeInstance((GuiInstance)instance));
    }

    public static void provideObject(UUID id, String key, Object value) {
        KasugaLib.STACKS.GUI.orElseThrow().getInstanceById(id).ifPresent(instance -> instance.putContextObject(key, value));
    }
}

