/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.base;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import kasuga.lib.core.KasugaLibStacks;
import kasuga.lib.core.channel.address.ConnectionInfo;
import kasuga.lib.core.channel.address.FeatureChannelPort;
import kasuga.lib.core.channel.address.Label;
import kasuga.lib.core.channel.network.address.MinecraftServerAddress;
import kasuga.lib.core.channel.peer.Channel;
import kasuga.lib.core.channel.peer.ChannelHandle;
import kasuga.lib.core.channel.peer.ChannelHandler;
import kasuga.lib.core.channel.peer.ChannelPeer;
import kasuga.lib.core.channel.peer.FeaturedChannelPeer;
import kasuga.lib.core.client.frontend.common.event.MessageEvent;
import kasuga.lib.core.menu.base.BindingClient;
import kasuga.lib.core.menu.base.GuiBinding;
import kasuga.lib.core.menu.base.GuiMenuType;
import kasuga.lib.core.menu.network.GuiClientMenuAddress;
import kasuga.lib.core.menu.network.GuiMenuNetworking;
import kasuga.lib.core.menu.network.GuiServerMenuAddress;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class GuiMenu {
    UUID id;
    protected GuiBinding binding;
    protected GuiMenuType<?> type;
    protected ChannelPeer peer;
    protected ChannelHandle handle;
    protected HashMap<Channel, ChannelHandle> handles = new HashMap();
    protected boolean isDifferentiated = false;
    protected boolean isServer = false;
    private ConnectionInfo remoteInfo;
    private boolean isGuiInstanceCreated = false;
    private UUID serverId;
    private boolean connectionFailure = false;
    private HashMap<String, Supplier<Object>> providers = new HashMap();
    int reconnection = 0;

    protected GuiMenu(GuiMenuType<?> type) {
        this.id = UUID.randomUUID();
        this.type = type;
        this.binding = this.createBinding(this.id);
    }

    protected GuiBinding createBinding(UUID id) {
        return new GuiBinding(id);
    }

    protected void createGuiInstance() {
        if (this.isGuiInstanceCreated) {
            return;
        }
        System.out.println("[Notice] GUI Instance Created");
        this.isGuiInstanceCreated = true;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            BindingClient.createInstance(this, this.id, this.binding.sourceCodeLocation);
            this.providers.forEach((key, value) -> BindingClient.provideObject(this.id, key, value.get()));
        });
    }

    protected void closeGuiInstance() {
        if (!this.isGuiInstanceCreated) {
            return;
        }
        System.out.println("[Notice] GUI Instance Closed");
        this.isGuiInstanceCreated = false;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> BindingClient.closeInstance(this.id));
    }

    public UUID asServer() {
        if (this.isDifferentiated) {
            if (!this.isServer) {
                throw new IllegalStateException("This is not a server instance");
            }
            return this.id;
        }
        this.isDifferentiated = true;
        this.isServer = true;
        FeaturedChannelPeer peer = new FeaturedChannelPeer(GuiServerMenuAddress.of(this.id));
        peer.openPort(FeatureChannelPort.of(KasugaLibStacks.REGISTRY.asResource("menu")), channelPeerSocketServer -> this.createServerHandler(channelPeerSocketServer.getChannel()));
        this.peer = peer;
        GuiMenuNetworking.getServerSwitcher().addPeer(peer);
        this.initServer();
        return this.id;
    }

    protected void initServer() {
    }

    public void asClient(UUID serverId) {
        if (this.serverId == serverId) {
            return;
        }
        if (this.isDifferentiated) {
            throw new IllegalStateException("This instance is already differentiated");
        }
        this.isDifferentiated = true;
        this.isServer = false;
        this.peer = new ChannelPeer(GuiClientMenuAddress.of(this.id));
        this.remoteInfo = ConnectionInfo.of(FeatureChannelPort.of(KasugaLibStacks.REGISTRY.asResource("menu")), GuiServerMenuAddress.of(serverId), (Label)MinecraftServerAddress.INSTANCE.get());
        this.serverId = serverId;
        GuiMenuNetworking.getClientSwitcher().addPeer(this.peer);
        this.peer.createSocket(this.remoteInfo, this.createClientHandler());
        this.initClient();
        KasugaLibStacks.MENU.addMenuTickInstance(this);
    }

    protected void initClient() {
    }

    private void clientForwardMessageToGuiInstance(CompoundTag message) {
        if (this.isGuiInstanceCreated) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> BindingClient.dispatchGuiEvent(this.id, new MessageEvent(true, message)));
        }
    }

    protected void setChannelHandle(ChannelHandle handle) {
        this.handle = handle;
    }

    private ChannelHandler createClientHandler() {
        return new ChannelHandler(){

            @Override
            public void onChannelEstabilished(ChannelHandle channel) {
                GuiMenu.this.connectionFailure = false;
                if (!GuiMenu.this.isDifferentiated) {
                    channel.close();
                    return;
                }
                GuiMenu.this.setChannelHandle(channel);
                GuiMenu.this.createGuiInstance();
            }

            @Override
            public void onChannelClose(ChannelHandle channel) {
                GuiMenu.this.connectionFailure = true;
                if (GuiMenu.this.isGuiInstanceCreated) {
                    GuiMenu.this.closeGuiInstance();
                }
                GuiMenu.this.setChannelHandle(null);
            }

            @Override
            public void onChannelMessage(ChannelHandle channel, CompoundTag payload) {
                if (!GuiMenu.this.isDifferentiated) {
                    channel.close();
                    return;
                }
                GuiMenu.this.clientForwardMessageToGuiInstance(payload);
            }
        };
    }

    private ChannelHandler createServerHandler(final Channel channel) {
        return new ChannelHandler(){

            @Override
            public void onChannelEstabilished(ChannelHandle handle) {
                if (!GuiMenu.this.isDifferentiated || !GuiMenu.this.isServer) {
                    channel.close();
                    return;
                }
                GuiMenu.this.handles.put(channel, handle);
                GuiMenu.this.onInit(channel, handle);
            }

            @Override
            public void onChannelClose(ChannelHandle handle) {
                GuiMenu.this.handles.remove(channel);
                GuiMenu.this.onClose(channel, handle);
            }

            @Override
            public void onChannelMessage(ChannelHandle handle, CompoundTag payload) {
                GuiMenu.this.onMesssage(channel, handle, payload);
            }
        };
    }

    public ChannelHandle getChannel() {
        return this.handle;
    }

    public ChannelHandle getChannel(ServerPlayer player) {
        return null;
    }

    public ChannelHandle getChannel(UUID clientId) {
        return null;
    }

    public void onInit(Channel channel, ChannelHandle handle) {
    }

    public void onClose(Channel channel, ChannelHandle handle) {
    }

    public void onMesssage(Channel channel, ChannelHandle handle, CompoundTag payload) {
    }

    public void close() {
        KasugaLibStacks.MENU.removeMenuTickInstance(this);
        if (this.isDifferentiated) {
            this.isDifferentiated = false;
            this.isServer = false;
            if (this.isServer) {
                List<ChannelHandle> handles$value = List.copyOf(this.handles.values());
                for (ChannelHandle handle : handles$value) {
                    handle.close();
                }
                GuiMenuNetworking.getServerSwitcher().removePeer(this.peer);
            } else {
                this.connectionFailure = false;
                this.reconnection = 20;
                if (this.isGuiInstanceCreated) {
                    this.closeGuiInstance();
                }
                if (this.handle != null) {
                    this.handle.close();
                }
                GuiMenuNetworking.getClientSwitcher().removePeer(this.peer);
            }
        }
    }

    public void broadcast(CompoundTag message) {
        if (this.isDifferentiated) {
            if (this.isServer) {
                for (ChannelHandle handle : this.handles.values()) {
                    handle.sendMessage(message);
                }
            } else if (this.handle != null) {
                this.handle.sendMessage(message);
            }
        }
    }

    public GuiBinding getBinding() {
        return this.binding;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getServerId() {
        return this.serverId;
    }

    public void clientTick() {
        if (this.isDifferentiated && !this.isServer) {
            if (this.connectionFailure) {
                if (--this.reconnection > 0) {
                    return;
                }
                this.reconnection = 20;
                this.connectionFailure = false;
                this.peer.createSocket(this.remoteInfo, this.createClientHandler());
            } else {
                this.reconnection = 20;
            }
        }
    }
}

