/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.behaviour;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.UUID;
import java.util.function.Supplier;
import kasuga.lib.core.menu.api.GuiMenuUtils;
import kasuga.lib.core.menu.base.GuiMenu;
import kasuga.lib.core.menu.network.BlockEntityMenuIdSyncPacket;
import kasuga.lib.core.packets.AllPackets;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class BlockEntityMenuBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<BlockEntityMenuBehaviour> TYPE = new BehaviourType();
    private final GuiMenu menuEntry;
    private UUID serverId;
    private final Supplier<GuiMenu> menuSupplier;

    public BlockEntityMenuBehaviour(SmartBlockEntity be, Supplier<GuiMenu> menuSupplier) {
        super(be);
        this.menuSupplier = menuSupplier;
        this.menuEntry = menuSupplier.get();
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void initialize() {
        Level level = this.getWorld();
        if (level != null && level instanceof ServerLevel) {
            this.menuEntry.asServer();
            this.sendMenuIdUpdate();
        }
    }

    public void sendMenuIdUpdate() {
        Level level = this.getWorld();
        if (level instanceof ServerLevel) {
            UUID serverId = this.menuEntry.asServer();
            BlockEntityMenuIdSyncPacket packet = new BlockEntityMenuIdSyncPacket(serverId, this.getPos(), (ResourceKey<Level>)level.m_46472_());
            AllPackets.CHANNEL_REG.getChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(this.getPos())), (Object)packet);
        }
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        if (!clientPacket) {
            return;
        }
        if (this.getWorld() instanceof ServerLevel) {
            nbt.m_128362_("menuId", this.menuEntry.getServerId());
        }
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        if (!clientPacket) {
            return;
        }
        if (nbt.m_128403_("menuId")) {
            this.serverId = nbt.m_128342_("menuId");
            this.notifyMenuId(this.serverId);
        }
    }

    public void notifyMenuId(UUID menuId) {
        if (menuId.equals(this.menuEntry.getServerId())) {
            return;
        }
        if (this.menuEntry != null) {
            this.menuEntry.close();
        }
        GuiMenu newMenu = this.menuSupplier.get();
        newMenu.asClient(menuId);
    }

    public void openScreen() {
        GuiMenuUtils.openScreen(this.menuEntry);
    }

    public void destroy() {
        this.menuEntry.close();
    }

    public GuiMenu getMenuEntry() {
        return this.menuEntry;
    }
}

