/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.javascript;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kasuga.lib.core.KasugaLibStacks;
import kasuga.lib.core.channel.peer.Channel;
import kasuga.lib.core.channel.peer.ChannelHandle;
import kasuga.lib.core.javascript.CompoundTagWrapper;
import kasuga.lib.core.javascript.JavascriptContext;
import kasuga.lib.core.menu.api.ChannelHandlerProxy;
import kasuga.lib.core.menu.api.ChannelProxy;
import kasuga.lib.core.menu.base.GuiMenu;
import kasuga.lib.core.menu.base.GuiMenuType;
import kasuga.lib.core.menu.javascript.JavascriptMenuHandle;
import kasuga.lib.core.menu.javascript.JavascriptMenuHandler;
import kasuga.lib.core.util.data_type.Pair;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public abstract class JavascriptMenu
extends GuiMenu {
    private final ResourceLocation location;
    JavascriptMenuHandle handle = new JavascriptMenuHandle(this);
    private Runnable sideEffect;
    private JavascriptContext context;
    private HashMap<Channel, ChannelHandle> connections = new HashMap();

    protected JavascriptMenu(GuiMenuType<?> type) {
        super(type);
        this.location = this.getServerScriptLocation();
    }

    public JavascriptMenuHandle getHandle() {
        return this.handle;
    }

    protected abstract ResourceLocation getServerScriptLocation();

    @Override
    protected void initServer() {
        super.initServer();
        this.openJavascriptServer();
    }

    @Override
    public void close() {
        super.close();
        this.closeJavascriptServer();
    }

    private void openJavascriptServer() {
        if (this.sideEffect != null) {
            return;
        }
        Pair handler = KasugaLibStacks.MENU.getJavascriptRegistry().get(this.location);
        KasugaLibStacks.MENU.getJavascriptRegistry().listenReload(this.location, this);
        if (handler == null) {
            return;
        }
        this.context = handler.getSecond();
        ArrayList<Map.Entry<Channel, ChannelHandle>> connections = new ArrayList<Map.Entry<Channel, ChannelHandle>>(this.connections.entrySet());
        handler.getSecond().runTask(() -> {
            this.sideEffect = ((JavascriptMenuHandler)handler.getFirst()).open(this.handle);
            connections.forEach(entry -> this.handle.dispatchEvent("connection", ChannelProxy.wrap((Channel)entry.getKey(), false), ChannelHandlerProxy.wrap((ChannelHandle)entry.getValue())));
        });
    }

    private CompletableFuture closeJavascriptServer() {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        KasugaLibStacks.MENU.getJavascriptRegistry().unlistenReload(this.location, this);
        if (this.sideEffect != null && this.context != null) {
            Runnable _sideEffect = this.sideEffect;
            this.context.runTask(() -> _sideEffect.run());
            this.sideEffect = null;
            this.context = null;
            future.complete(new Object());
        } else if (this.context != null) {
            this.context.runTask(() -> {
                this.connections.forEach((channel, socketHandle) -> this.handle.dispatchEvent("disconnection", ChannelProxy.wrap(channel, false), ChannelHandlerProxy.wrap(socketHandle)));
                this.closeJavascriptServer().thenRun(() -> future.complete(new Object()));
            });
        } else {
            future.complete(new Object());
        }
        return future;
    }

    public void reload() {
        if (this.context != null) {
            this.closeJavascriptServer().thenRun(() -> {
                for (ChannelHandle handle : this.handles.values()) {
                    handle.close();
                }
                this.openJavascriptServer();
            });
        } else {
            for (ChannelHandle handle : this.handles.values()) {
                handle.close();
            }
            this.openJavascriptServer();
        }
    }

    protected void provide(String key, Object value) {
        this.handle.nativeObjects.put(key, value);
    }

    protected boolean hasProvide(String key) {
        return this.handle.nativeObjects.containsKey(key);
    }

    @Override
    public void onInit(Channel channel, ChannelHandle socketHandle) {
        super.onInit(channel, socketHandle);
        if (this.context != null) {
            this.context.runTask(() -> this.handle.dispatchEvent("connection", ChannelProxy.wrap(channel, false), ChannelHandlerProxy.wrap(socketHandle)));
        }
        this.connections.put(channel, socketHandle);
    }

    @Override
    public void onMesssage(Channel channel, ChannelHandle socketHandle, CompoundTag payload) {
        super.onMesssage(channel, socketHandle, payload);
        if (this.context != null) {
            this.context.runTask(() -> this.handle.dispatchEvent("message", new CompoundTagWrapper(payload), ChannelProxy.wrap(channel, false), ChannelHandlerProxy.wrap(socketHandle)));
        }
    }

    @Override
    public void onClose(Channel channel, ChannelHandle socketHandle) {
        super.onClose(channel, socketHandle);
        if (this.context != null) {
            this.context.runTask(() -> this.handle.dispatchEvent("disconnection", ChannelProxy.wrap(channel, false), ChannelHandlerProxy.wrap(socketHandle)));
        }
        this.connections.remove(channel);
    }
}

