/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.javascript;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kasuga.lib.core.javascript.JavascriptContext;
import kasuga.lib.core.javascript.engine.JavascriptValue;
import kasuga.lib.core.javascript.registration.JavascriptPriorityRegistry;
import kasuga.lib.core.menu.javascript.JavascriptMenu;
import kasuga.lib.core.menu.javascript.JavascriptMenuHandler;
import net.minecraft.resources.ResourceLocation;

public class JavascriptMenuRegistry
extends JavascriptPriorityRegistry<JavascriptMenuHandler> {
    HashMap<ResourceLocation, HashSet<JavascriptMenu>> menus = new HashMap();

    @Override
    public JavascriptMenuHandler fromValue(JavascriptContext context, JavascriptValue value) {
        if (value.canExecute()) {
            value.pin();
            return JavascriptMenuHandler.ofExecutable(context.getRuntimeContext(), value);
        }
        throw new IllegalStateException("Value is not executable");
    }

    @Override
    public void register(JavascriptContext self, ResourceLocation location, JavascriptMenuHandler item) {
        super.register(self, location, item);
        this.dispatchReload(location);
    }

    @Override
    public void unregister(JavascriptContext self, ResourceLocation location, JavascriptMenuHandler item) {
        super.unregister(self, location, item);
        this.dispatchReload(location);
    }

    public void listenReload(ResourceLocation id, JavascriptMenu menu) {
        this.menus.computeIfAbsent(id, k -> new HashSet()).add(menu);
    }

    public void unlistenReload(ResourceLocation id, JavascriptMenu menu) {
        if (!this.menus.containsKey(id)) {
            return;
        }
        this.menus.get(id).remove(menu);
        if (this.menus.get(id).isEmpty()) {
            this.menus.remove(id);
        }
    }

    private void dispatchReload(ResourceLocation id) {
        if (!this.menus.containsKey(id)) {
            return;
        }
        ArrayList pendingUpdateMenus = new ArrayList(this.menus.get(id));
        for (JavascriptMenu menu : pendingUpdateMenus) {
            menu.reload();
        }
    }
}

