/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.locator;

import java.util.List;
import kasuga.lib.core.menu.locator.IChunkBasedLocator;
import kasuga.lib.core.menu.locator.LocatedMenuManager;
import kasuga.lib.core.menu.locator.MenuLocator;
import kasuga.lib.core.menu.locator.MenuLocatorType;
import kasuga.lib.core.menu.locator.ServerChunkMenuLocatorManager;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public abstract class AbstractChunkBasedLocator
extends MenuLocator
implements IChunkBasedLocator {
    protected Level level;
    protected ResourceKey<Level> levelResourceKey;
    protected final ChunkPos chunkPos;

    protected AbstractChunkBasedLocator(MenuLocatorType<?> type, ChunkPos chunkPos) {
        super(type);
        this.chunkPos = chunkPos;
    }

    protected AbstractChunkBasedLocator(MenuLocatorType<?> type, FriendlyByteBuf byteBuf) {
        super(type);
        this.chunkPos = byteBuf.m_178383_();
        this.levelResourceKey = byteBuf.m_236801_(Registry.f_122819_);
    }

    @Override
    public void write(FriendlyByteBuf byteBuf) {
        byteBuf.m_178341_(this.chunkPos);
        byteBuf.m_236858_(this.levelResourceKey);
    }

    public void withLevel(Level level) {
        if (this.levelResourceKey != null) {
            return;
        }
        this.level = level;
        this.levelResourceKey = level.m_46472_();
    }

    @Override
    public void enable(LocatedMenuManager manager) {
        super.enable(manager);
        this.listen();
        if (!this.level.m_7232_(this.chunkPos.f_45578_, this.chunkPos.f_45579_)) {
            return;
        }
        this.broadcastEnable();
    }

    protected void broadcastEnable() {
        List players = ((ServerChunkCache)this.level.m_7726_()).f_8325_.m_183262_(this.chunkPos, false);
        if (players == null) {
            return;
        }
        for (ServerPlayer player : players) {
            this.sendUpTo(player.f_8906_.m_6198_());
        }
    }

    protected void listen() {
        ServerChunkMenuLocatorManager.register(this);
    }

    protected void unlisten() {
        ServerChunkMenuLocatorManager.unregister(this);
    }

    @Override
    public void disable(LocatedMenuManager manager) {
        this.broadcastDisable();
        super.disable(manager);
        this.unlisten();
    }

    @Override
    public ChunkPos getPosition() {
        return this.chunkPos;
    }
}

