/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.locator;

import kasuga.lib.core.menu.locator.AbstractChunkBasedLocator;
import kasuga.lib.core.menu.locator.MenuLocatorType;
import kasuga.lib.core.menu.locator.ServerChunkMenuLocatorManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;

public abstract class AbstractDynamicChunkBasedLocator
extends AbstractChunkBasedLocator {
    ChunkPos latestPos;

    protected AbstractDynamicChunkBasedLocator(MenuLocatorType<?> type, ChunkPos chunkPos) {
        super(type, chunkPos);
        this.latestPos = chunkPos;
    }

    protected AbstractDynamicChunkBasedLocator(MenuLocatorType<?> type, FriendlyByteBuf byteBuf) {
        super(type, byteBuf);
    }

    @Override
    public void write(FriendlyByteBuf byteBuf) {
        super.write(byteBuf);
    }

    @Override
    protected void listen() {
        ServerChunkMenuLocatorManager.register(this, this.latestPos);
    }

    @Override
    protected void unlisten() {
        ServerChunkMenuLocatorManager.unregister(this, this.latestPos);
    }

    protected void transfer(ChunkPos newChunk) {
        if (this.latestPos == newChunk) {
            return;
        }
        ServerChunkMenuLocatorManager.transfer(this, this.latestPos, newChunk);
        this.latestPos = newChunk;
    }
}

