/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.locator;

import java.util.Objects;
import kasuga.lib.core.menu.locator.AbstractChunkBasedLocator;
import kasuga.lib.core.menu.locator.MenuLocatorTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class BlockMenuLocator
extends AbstractChunkBasedLocator {
    private final BlockPos blockPos;

    public BlockMenuLocator(BlockPos blockPos) {
        super(MenuLocatorTypes.BLOCK, new ChunkPos(blockPos));
        this.blockPos = blockPos;
    }

    public BlockMenuLocator(FriendlyByteBuf byteBuf) {
        super(MenuLocatorTypes.BLOCK, byteBuf);
        this.blockPos = byteBuf.m_130135_();
    }

    public BlockMenuLocator(Level level, BlockPos blockPos) {
        this(blockPos);
        this.withLevel(level);
    }

    @Override
    public void write(FriendlyByteBuf byteBuf) {
        super.write(byteBuf);
        byteBuf.m_130064_(this.blockPos);
    }

    public static BlockMenuLocator of(Level level, BlockPos blockPos) {
        return new BlockMenuLocator(level, blockPos);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BlockMenuLocator that = (BlockMenuLocator)object;
        return Objects.equals(this.levelResourceKey, that.levelResourceKey) && Objects.equals(this.blockPos, that.blockPos);
    }

    public int hashCode() {
        return Objects.hash(this.levelResourceKey, this.blockPos);
    }
}

