/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.locator;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import kasuga.lib.core.KasugaLibStacks;
import kasuga.lib.core.menu.base.GuiMenu;
import kasuga.lib.core.menu.base.GuiMenuType;
import kasuga.lib.core.menu.locator.LocatedMenuManager;
import kasuga.lib.core.menu.locator.MenuLocator;
import net.minecraft.world.level.LevelAccessor;

public class GuiMenuHolder {
    private final List<GuiMenu> menus = new ArrayList<GuiMenu>();
    private LocatedMenuManager manager;
    private MenuLocator locator;
    private final LocatedMenuManager.Type managerType;
    private boolean isServer = false;
    private boolean isEnabled = false;

    private GuiMenuHolder(LocatedMenuManager.Type managerType, MenuLocator locator) {
        this.managerType = managerType;
        this.locator = locator;
    }

    public void enableServer(MenuLocator locator) {
        if (this.manager != null) {
            return;
        }
        this.isEnabled = true;
        this.isServer = true;
        this.manager = this.managerType.create();
        this.manager.asServer();
        KasugaLibStacks.MENU.addServerLocator(locator, this.manager);
    }

    public void enableClient(MenuLocator locator) {
        if (this.manager != null) {
            return;
        }
        this.isEnabled = true;
        this.isServer = false;
        this.manager = this.managerType.create();
        KasugaLibStacks.MENU.addClientLocator(locator, this.manager);
    }

    public void enable(LevelAccessor level) {
        if (this.isEnabled) {
            return;
        }
        if (level.m_5776_()) {
            this.enableClient(this.locator);
        } else {
            this.enableServer(this.locator);
        }
    }

    public void disable() {
        if (this.manager == null || !this.isEnabled) {
            return;
        }
        if (this.locator != null) {
            if (this.isServer) {
                KasugaLibStacks.MENU.removeServerLocator(this.locator);
            } else {
                KasugaLibStacks.MENU.removeClientLocator(this.locator);
            }
        }
        this.manager = null;
        this.locator = null;
        this.isEnabled = false;
        this.isServer = false;
    }

    public Optional<GuiMenu> getMenu(int index) {
        if (this.manager == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.manager.getMenu(index));
    }

    public void openScreen(int index) {
        if (this.manager == null) {
            return;
        }
        this.manager.openScreen(index);
    }

    public MenuLocator getLocator() {
        return this.locator;
    }

    public static class Builder {
        private final LocatedMenuManager.Builder managerBuilder = new LocatedMenuManager.Builder();
        private MenuLocator locator;

        public Builder with(GuiMenuType<?> menuType) {
            this.managerBuilder.with(menuType);
            return this;
        }

        public <T extends GuiMenu> Builder with(GuiMenuType<T> menuType, Consumer<T> initialParameter) {
            this.managerBuilder.with(menuType, initialParameter);
            return this;
        }

        public Builder locatedAt(MenuLocator locator) {
            this.locator = locator;
            return this;
        }

        public GuiMenuHolder build() {
            if (this.locator == null) {
                throw new IllegalStateException("Locator must be set");
            }
            return new GuiMenuHolder(this.managerBuilder.build(), this.locator);
        }
    }
}

