/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.locator;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import kasuga.lib.core.menu.base.GuiMenu;
import kasuga.lib.core.menu.base.GuiMenuType;
import kasuga.lib.core.menu.targets.ClientScreenTarget;

public class LocatedMenuManager {
    private ArrayList<GuiMenuType<?>> menuSuppliers = new ArrayList();
    private ArrayList<GuiMenu> menus = new ArrayList();
    private ArrayList<Consumer<GuiMenu>> menuInitializers = new ArrayList();

    public void close() {
        for (GuiMenu menu : this.menus) {
            if (menu == null) continue;
            menu.close();
        }
    }

    public void register(GuiMenuType<?> menuType, Consumer<GuiMenu> initializer) {
        this.menuSuppliers.add(menuType);
        this.menuInitializers.add(initializer);
    }

    public ArrayList<UUID> asServer() {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (GuiMenu menu : this.menus) {
            uuids.add(menu.asServer());
        }
        return uuids;
    }

    public void asClient(List<UUID> uuids) {
        this.reset();
        ArrayList<UUID> newUuids = new ArrayList<UUID>(uuids);
        for (GuiMenu menu : this.menus) {
            if (uuids.isEmpty()) break;
            menu.asClient((UUID)newUuids.remove(0));
        }
    }

    public void init() {
        for (int i = 0; i < this.menuSuppliers.size(); ++i) {
            this.menus.add(null);
        }
    }

    public void reset() {
        for (int i = 0; i < this.menuSuppliers.size(); ++i) {
            if (i >= 0 && i < this.menus.size() && this.menus.get(i) != null) {
                this.menus.get(i).close();
            }
            Object menu = this.menuSuppliers.get(i).create();
            this.menuInitializers.get(i).accept((GuiMenu)menu);
            this.menus.set(i, (GuiMenu)menu);
        }
    }

    public GuiMenu getMenu(int index) {
        if (index < 0 || index >= this.menus.size()) {
            return null;
        }
        return this.menus.get(index);
    }

    public void openScreen(int index) {
        GuiMenu menu = this.getMenu(index);
        if (menu == null) {
            return;
        }
        ClientScreenTarget.openScreen(menu);
    }

    public List<UUID> getIdentifiers() {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (GuiMenu menu : this.menus) {
            uuids.add(menu.getId());
        }
        return uuids;
    }

    public static class Builder {
        private List<GuiMenuType<?>> menuSuppliers = new ArrayList();
        private List<Consumer<GuiMenu>> menuInitializers = new ArrayList<Consumer<GuiMenu>>();

        public Builder with(GuiMenuType<?> menu) {
            this.menuSuppliers.add(menu);
            this.menuInitializers.add(m -> {});
            return this;
        }

        public Builder with(GuiMenuType<?> menu, Consumer<GuiMenu> initializer) {
            this.menuSuppliers.add(menu);
            this.menuInitializers.add(initializer);
            return this;
        }

        public Type build() {
            return () -> {
                LocatedMenuManager manager = new LocatedMenuManager();
                for (int i = 0; i < this.menuSuppliers.size(); ++i) {
                    manager.register(this.menuSuppliers.get(i), this.menuInitializers.get(i));
                }
                manager.init();
                manager.reset();
                return manager;
            };
        }
    }

    public static interface Type {
        public LocatedMenuManager create();
    }
}

