/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.locator;

import java.util.HashSet;
import kasuga.lib.core.channel.network.NetworkSeriaizableType;
import kasuga.lib.core.channel.network.NetworkSerializable;
import kasuga.lib.core.menu.locator.LocatedMenuManager;
import kasuga.lib.core.menu.locator.MenuLocatorType;
import kasuga.lib.core.menu.network.ServerLocatorChangePacket;
import kasuga.lib.core.packets.AllPackets;
import net.minecraft.network.Connection;
import net.minecraftforge.network.NetworkDirection;

public abstract class MenuLocator
implements NetworkSerializable {
    private NetworkSeriaizableType<?> type;
    private LocatedMenuManager manager;
    protected final HashSet<Connection> tracking = new HashSet();

    public MenuLocator(MenuLocatorType<?> type) {
        this.type = type;
    }

    @Override
    public NetworkSeriaizableType<?> getType() {
        return this.type;
    }

    public void enable(LocatedMenuManager manager) {
        this.manager = manager;
    }

    public void disable(LocatedMenuManager manager) {
        this.manager = null;
        this.broadcastDisable();
    }

    public void sendUpTo(Connection connection) {
        if (!connection.m_129536_()) {
            return;
        }
        AllPackets.CHANNEL_REG.sendTo(new ServerLocatorChangePacket(this, this.manager.asServer()), connection, NetworkDirection.PLAY_TO_CLIENT);
        this.tracking.add(connection);
    }

    public void sendDownTo(Connection connection) {
        if (!connection.m_129536_()) {
            return;
        }
        AllPackets.CHANNEL_REG.sendTo(new ServerLocatorChangePacket(this, this.manager.asServer()), connection, NetworkDirection.PLAY_TO_CLIENT);
        this.tracking.remove(connection);
    }

    protected void broadcastDisable() {
        for (Connection connection : this.tracking) {
            this.sendDownTo(connection);
        }
        this.tracking.clear();
    }

    public void tick() {
    }
}

