/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.locator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kasuga.lib.core.menu.locator.IChunkBasedLocator;
import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.event.level.ChunkWatchEvent;

public class ServerChunkMenuLocatorManager {
    public static HashMap<ChunkPos, List<IChunkBasedLocator>> chunks = new HashMap();
    public static HashMap<ChunkPos, List<ServerPlayer>> players = new HashMap();

    public static void register(IChunkBasedLocator menuLocator, ChunkPos position) {
        chunks.computeIfAbsent(position, k -> new ArrayList()).add(menuLocator);
    }

    public static void register(IChunkBasedLocator menuLocator) {
        ServerChunkMenuLocatorManager.register(menuLocator, menuLocator.getPosition());
    }

    public static void unregister(IChunkBasedLocator menuLocator, ChunkPos position) {
        if (chunks.containsKey(position)) {
            List<IChunkBasedLocator> locators = chunks.get(position);
            locators.remove(menuLocator);
            if (locators.isEmpty()) {
                chunks.remove(position);
            }
        }
    }

    public static void unregister(IChunkBasedLocator menuLocator) {
        ServerChunkMenuLocatorManager.unregister(menuLocator, menuLocator.getPosition());
    }

    public static void notifyLoad(ChunkPos position, Connection connection) {
        if (chunks.containsKey(position)) {
            chunks.get(position).forEach(locator -> locator.sendUpTo(connection));
        }
    }

    public static void notifyUnload(ChunkPos position, Connection connection) {
        if (chunks.containsKey(position)) {
            chunks.get(position).forEach(locator -> locator.sendDownTo(connection));
        }
    }

    public static void onWatch(ChunkWatchEvent.Watch watchEvent) {
        players.computeIfAbsent(watchEvent.getPos(), k -> new ArrayList()).add(watchEvent.getPlayer());
        ServerChunkMenuLocatorManager.notifyLoad(watchEvent.getPos(), watchEvent.getPlayer().f_8906_.m_6198_());
    }

    public static void onUnWatch(ChunkWatchEvent.UnWatch unwatchEvent) {
        if (players.containsKey(unwatchEvent.getPos())) {
            List<ServerPlayer> playerList = players.get(unwatchEvent.getPos());
            playerList.remove(unwatchEvent.getPlayer());
            if (playerList.isEmpty()) {
                players.remove(unwatchEvent.getPos());
            }
        }
        ServerChunkMenuLocatorManager.notifyUnload(unwatchEvent.getPos(), unwatchEvent.getPlayer().f_8906_.m_6198_());
    }

    public static void transfer(IChunkBasedLocator menuLocator, ChunkPos oldChunk, ChunkPos newChunk) {
        chunks.computeIfAbsent(newChunk, k -> new ArrayList()).add(menuLocator);
        if (chunks.containsKey(oldChunk)) {
            chunks.get(oldChunk).remove(menuLocator);
        }
        List<ServerPlayer> oldPlayers = players.get(oldChunk);
        List<ServerPlayer> newPlayers = players.get(newChunk);
        if (oldPlayers != null) {
            oldPlayers.stream().filter(player -> newPlayers == null ? true : !newPlayers.contains(player)).forEach(player -> menuLocator.sendDownTo(player.f_8906_.m_6198_()));
        }
        if (newPlayers != null) {
            newPlayers.stream().filter(player -> oldPlayers == null ? true : !oldPlayers.contains(player)).forEach(player -> menuLocator.sendUpTo(player.f_8906_.m_6198_()));
        }
    }
}

