/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.network;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kasuga.lib.core.KasugaLibStacks;
import kasuga.lib.core.menu.locator.MenuLocator;
import kasuga.lib.core.network.S2CPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;

public class ServerLocatorChangePacket
extends S2CPacket {
    private final MenuLocator locator;
    private final List<UUID> knownData;

    public ServerLocatorChangePacket(MenuLocator locator, List<UUID> knownData) {
        this.locator = locator;
        this.knownData = knownData;
    }

    public ServerLocatorChangePacket(FriendlyByteBuf buf) {
        this.locator = (MenuLocator)KasugaLibStacks.MENU.getLocatorRegistry().read(buf);
        this.knownData = new ArrayList<UUID>();
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            this.knownData.add(buf.m_130259_());
        }
    }

    @Override
    public void handle(Minecraft minecraft) {
        KasugaLibStacks.MENU.notifyMenuChange(this.locator, this.knownData);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        KasugaLibStacks.MENU.getLocatorRegistry().write(this.locator, buf);
        buf.m_130130_(this.knownData.size());
        for (UUID uuid : this.knownData) {
            buf.m_130077_(uuid);
        }
    }

    public MenuLocator getLocator() {
        return this.locator;
    }

    public List<UUID> getKnownData() {
        return this.knownData;
    }
}

