/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.sync;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import kasuga.lib.core.sync.DataState;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class DataSynchronizer {
    protected ArrayList<DataState> states = new ArrayList();
    protected ArrayList<Function<Integer, DataState>> stateSuppliers = new ArrayList();
    protected HashMap<Object, ArrayList<DataState>> remoteStates = new HashMap();
    protected HashMap<Object, Consumer<CompoundTag>> remoteConsumers = new HashMap();

    public void addRemote(Object object, Consumer<CompoundTag> tagConsumer) {
        int i;
        this.remoteConsumers.put(object, tagConsumer);
        ArrayList<DataState> remote = new ArrayList<DataState>();
        for (i = 0; i < this.states.size(); ++i) {
            remote.add(this.stateSuppliers.get(i).apply(i));
        }
        this.remoteStates.put(object, remote);
        for (i = 0; i < this.states.size(); ++i) {
            this.sendStateDiff(object, i);
        }
    }

    public void removeRemote(Object object) {
        this.remoteConsumers.remove(object);
        this.remoteStates.remove(object);
    }

    public void registerState(DataState initialState, Function<Integer, DataState> dataSupplier) {
        int newId = this.states.size();
        this.states.add(initialState);
        this.stateSuppliers.add(dataSupplier);
        for (Object remote : this.remoteStates.keySet()) {
            ArrayList<DataState> remoteStateList = this.remoteStates.get(remote);
            remoteStateList.add(dataSupplier.apply(newId));
        }
        this.updateState(newId, initialState);
    }

    public void updateState(int stateId, DataState newState) {
        if (stateId >= 0 && stateId < this.states.size()) {
            DataState oldState = this.states.get(stateId);
            this.states.set(stateId, newState);
            for (Object remote : this.remoteConsumers.keySet()) {
                this.sendStateDiff(remote, stateId);
            }
        }
    }

    private void sendStateDiff(Object remote, int stateId) {
        DataState remoteState;
        ListTag diffList = new ListTag();
        DataState localState = this.states.get(stateId);
        CompoundTag diff = localState.diff(remoteState = this.remoteStates.get(remote).get(stateId));
        if (diff != null) {
            diff.m_128405_("index", stateId);
            diffList.add((Object)diff);
        }
        if (!diffList.isEmpty()) {
            CompoundTag packet = new CompoundTag();
            packet.m_128365_("diffs", (Tag)diffList);
            this.remoteConsumers.get(remote).accept(packet);
        }
    }

    public void handleRemoteUpdate(Object sender, CompoundTag packet) {
        ListTag diffs = packet.m_128437_("diffs", 10);
        for (int i = 0; i < diffs.size(); ++i) {
            CompoundTag diffTag = diffs.m_128728_(i);
            int stateId = diffTag.m_128451_("index");
            if (stateId < 0 || stateId >= this.states.size()) continue;
            DataState state = this.states.get(stateId);
            state.applyDiff(diffTag);
        }
    }

    public DataState getRemoteState(Object sender, int stateId) {
        ArrayList<DataState> senderStates = this.remoteStates.get(sender);
        if (senderStates != null && stateId < senderStates.size()) {
            return senderStates.get(stateId);
        }
        return null;
    }

    public void syncAllStates(Object remote) {
        ListTag diffList = new ListTag();
        for (int i = 0; i < this.states.size(); ++i) {
            DataState remoteState;
            DataState localState = this.states.get(i);
            CompoundTag diff = localState.diff(remoteState = this.remoteStates.get(remote).get(i));
            if (diff == null) continue;
            diff.m_128405_("index", i);
            diffList.add((Object)diff);
        }
        if (!diffList.isEmpty()) {
            CompoundTag packet = new CompoundTag();
            packet.m_128365_("diffs", (Tag)diffList);
            this.remoteConsumers.get(remote).accept(packet);
        }
    }
}

