/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.util;

import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class MultipleReader
extends Reader {
    Reader[] readers = new Reader[0];
    AtomicInteger readerIndex = new AtomicInteger(0);

    public MultipleReader(Reader ... readers) {
        this.readers = readers;
    }

    @Override
    public int read(@NotNull char[] cbuf, int off, int len) throws IOException {
        int cnt = 0;
        int nextOff = off;
        int remain = len;
        while (this.readerIndex.get() < this.readers.length) {
            int curCnt = this.readers[this.readerIndex.get()].read(cbuf, nextOff, remain);
            if (curCnt == -1) {
                this.readerIndex.incrementAndGet();
                continue;
            }
            nextOff += curCnt;
            cnt += curCnt;
            if ((remain -= curCnt) > 0) continue;
            break;
        }
        return this.readerIndex.get() < this.readers.length || cnt != 0 ? cnt : -1;
    }

    @Override
    public void close() throws IOException {
        for (Reader reader : this.readers) {
            reader.close();
        }
    }
}

