/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.util.nbt_json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import kasuga.lib.core.util.nbt_json.ConversionPair;
import kasuga.lib.core.util.nbt_json.Converter;
import kasuga.lib.core.util.nbt_json.NoAvailableConversionException;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class CompoundPair
extends ConversionPair<CompoundTag, JsonObject> {
    public final Converter converter;

    public CompoundPair(Converter converter) {
        super("compound", CompoundTag.class, JsonObject.class);
        this.converter = converter;
    }

    @Override
    public JsonObject convert(@NotNull CompoundTag nbt, String path) throws NoAvailableConversionException {
        JsonObject object = new JsonObject();
        for (String key : nbt.m_128431_()) {
            Tag tag = nbt.m_128423_(key);
            object.add(key, (JsonElement)this.converter.innerConvert(tag, path + "." + key));
        }
        return object;
    }

    @Override
    public CompoundTag convert(@NotNull JsonObject json, String path) throws NoAvailableConversionException {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry entry : json.entrySet()) {
            nbt.m_128365_((String)entry.getKey(), (Tag)this.converter.innerConvert(entry.getValue(), path + "." + (String)entry.getKey()));
        }
        return nbt;
    }

    @Generated
    public Converter getConverter() {
        return this.converter;
    }
}

