/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.util.nbt_json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.util.nbt_json.AllConversionPairs;
import kasuga.lib.core.util.nbt_json.CompoundPair;
import kasuga.lib.core.util.nbt_json.ConversionPair;
import kasuga.lib.core.util.nbt_json.NoAvailableConversionException;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Converter {
    private final HashMap<String, ConversionPair> pairs = new HashMap();
    private ConverterSelector globalSelector;
    private final HashMap<String, ConverterSelector> pathSelectors;
    private final HashMap<ConversionPair, ConverterSelector> selectors = new HashMap();

    public Converter() {
        this.pathSelectors = new HashMap();
    }

    public Converter(ConversionPair ... pairs) {
        this();
        for (ConversionPair pair : pairs) {
            this.pairs.put(pair.identifier, pair);
        }
    }

    public void addDefaultConversions() {
        this.addConversion(AllConversionPairs.BOOLEAN_PAIR);
        this.addConversion(AllConversionPairs.STRING_PAIR);
        this.addConversion(AllConversionPairs.BYTE_PAIR);
        this.addConversion(AllConversionPairs.DOUBLE_PAIR);
        this.addConversion(AllConversionPairs.FLOAT_PAIR);
        this.addConversion(AllConversionPairs.INT_PAIR);
        this.addConversion(AllConversionPairs.LONG_PAIR);
        this.addConversion(AllConversionPairs.SHORT_PAIR);
        this.addConversion(AllConversionPairs.BYTE_ARRAY_PAIR);
        this.addConversion(AllConversionPairs.INT_ARRAY_PAIR);
        this.addConversion(AllConversionPairs.LONG_ARRAY_PAIR);
        this.addConversion(new CompoundPair(this));
    }

    public void markAs(String path, String identifier) {
        this.pathSelectors.put(path, (a, b, c, d, e) -> this.pairs.get(identifier));
    }

    public void addConversion(ConversionPair pair) {
        this.pairs.put(pair.identifier, pair);
    }

    public void addSelector(ConversionPair pair, ConverterSelector selector) {
        this.selectors.put(pair, selector);
    }

    public void addPathSelector(String path, ConverterSelector selector) {
        this.pathSelectors.put(path, selector);
    }

    public ConversionPair getPair(String identifier) {
        return this.pairs.getOrDefault(identifier, null);
    }

    public ConverterSelector getSelector(ConversionPair pair) {
        return this.selectors.getOrDefault(pair, null);
    }

    public boolean hasGlobalSelector() {
        return this.globalSelector != null;
    }

    public @NonNull JsonElement convert(@NonNull Tag tag) throws NoAvailableConversionException {
        return (JsonElement)this.innerConvert(tag, "root");
    }

    public @NonNull Tag convert(@NonNull JsonElement element) throws NoAvailableConversionException {
        return (Tag)this.innerConvert(element, "root");
    }

    public @NonNull JsonElement safeConvert(@NonNull Tag tag) {
        return (JsonElement)this.safeInnerConvert(tag, "root");
    }

    public @NonNull Tag safeConvert(@NonNull JsonElement element) {
        return (Tag)this.safeInnerConvert(element, "root");
    }

    protected @NonNull Object safeInnerConvert(Object input, String path) {
        try {
            return this.innerConvert(input, path);
        }
        catch (NoAvailableConversionException e) {
            KasugaLib.MAIN_LOGGER.debug("Error in nbt convert: ", (Throwable)e);
            if (input instanceof Tag) {
                return new JsonObject();
            }
            return new CompoundTag();
        }
    }

    protected @NonNull Object innerConvert(Object input, String path) throws NoAvailableConversionException {
        boolean flag = input instanceof Tag;
        Direction direction = flag ? Direction.NBT_TO_JSON : Direction.JSON_TO_NBT;
        Tag tag = flag ? (Tag)input : null;
        JsonElement element = !flag ? (JsonElement)input : null;
        ConversionPair pair = null;
        for (Map.Entry<String, ConverterSelector> entry : this.pathSelectors.entrySet()) {
            if (!entry.getKey().equals(path)) continue;
            ConversionPair cache = entry.getValue().select(this, tag, element, path, direction);
            if (!(flag ? cache.match(tag) : cache.match(element))) continue;
            pair = cache;
            break;
        }
        if (pair == null) {
            for (Map.Entry<Object, ConverterSelector> entry : this.selectors.entrySet()) {
                if (!((ConversionPair)entry.getKey()).match(tag)) continue;
                pair = entry.getValue().select(this, tag, element, path, direction);
                break;
            }
        }
        if (this.globalSelector != null && pair == null) {
            pair = this.globalSelector.select(this, tag, element, path, direction);
        }
        if (pair == null) {
            if (flag || !element.isJsonPrimitive() && !element.isJsonArray()) {
                for (Map.Entry<Object, Object> entry : this.pairs.entrySet()) {
                    if (!(flag ? ((ConversionPair)entry.getValue()).match(tag) : ((ConversionPair)entry.getValue()).match(element))) continue;
                    pair = (ConversionPair)entry.getValue();
                    break;
                }
            } else if (element.isJsonPrimitive()) {
                if (this.getPair("str").match(element)) {
                    pair = this.getPair("str");
                } else if (this.getPair("bool").match(element)) {
                    pair = this.getPair("bool");
                } else if (this.getPair("int").match(element)) {
                    pair = this.getPair("int");
                } else if (this.getPair("short").match(element)) {
                    pair = this.getPair("short");
                } else if (this.getPair("long").match(element)) {
                    pair = this.getPair("long");
                } else if (this.getPair("float").match(element)) {
                    pair = this.getPair("float");
                } else if (this.getPair("double").match(element)) {
                    pair = this.getPair("double");
                }
            } else {
                JsonArray array = new JsonArray();
                if (array.isEmpty()) {
                    return new ListTag();
                }
                JsonElement jsonElement = array.get(0);
                if (jsonElement.isJsonPrimitive()) {
                    JsonPrimitive primitive = jsonElement.getAsJsonPrimitive();
                    if (this.getPair("int").match((JsonElement)primitive)) {
                        pair = this.getPair("int_array");
                    } else if (this.getPair("long").match((JsonElement)primitive)) {
                        pair = this.getPair("long_array");
                    } else if (this.getPair("byte").match((JsonElement)primitive)) {
                        pair = this.getPair("byte_array");
                    }
                } else {
                    ListTag listTag = new ListTag();
                    for (JsonElement inner : array) {
                        listTag.add((Object)((Tag)this.innerConvert(inner, path)));
                    }
                    return listTag;
                }
            }
        }
        if (pair == null) {
            throw new NoAvailableConversionException(tag.getClass(), path);
        }
        return flag ? pair.convert(tag, path) : pair.convert(element, path);
    }

    @Generated
    public HashMap<String, ConversionPair> getPairs() {
        return this.pairs;
    }

    @Generated
    public ConverterSelector getGlobalSelector() {
        return this.globalSelector;
    }

    @Generated
    public HashMap<String, ConverterSelector> getPathSelectors() {
        return this.pathSelectors;
    }

    @Generated
    public HashMap<ConversionPair, ConverterSelector> getSelectors() {
        return this.selectors;
    }

    @Generated
    public void setGlobalSelector(ConverterSelector globalSelector) {
        this.globalSelector = globalSelector;
    }

    public static interface ConverterSelector {
        public ConversionPair select(Converter var1, @Nullable Tag var2, @Nullable JsonElement var3, String var4, Direction var5);
    }

    public static enum Direction {
        JSON_TO_NBT,
        NBT_TO_JSON;

    }
}

