/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.util.nbt_json;

import java.util.HashSet;
import java.util.List;
import kasuga.lib.core.util.nbt_json.ConversionPair;
import kasuga.lib.core.util.nbt_json.Converter;
import kasuga.lib.core.util.nbt_json.ListIsEmptyException;
import kasuga.lib.core.util.nbt_json.NoAvailableConversionException;
import kasuga.lib.core.util.nbt_json.collection.ListPair;
import lombok.Generated;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class TemplateConverter
extends Converter {
    private final Tag template;
    private final HashSet<String> boolTags;

    public TemplateConverter(Tag template) {
        this.template = template;
        this.boolTags = new HashSet();
    }

    public void markAsBoolTag(String ... path) {
        this.boolTags.addAll(List.of(path));
    }

    public boolean isMarkedAsBoolTag(String path) {
        return this.boolTags.contains(path);
    }

    public void compile() throws ListIsEmptyException, NoAvailableConversionException {
        this.updateSelector(this.template, "root");
    }

    public boolean safeCompile() {
        return this.safeUpdateSelector(this.template, "root");
    }

    private void updateSelector(Tag tag, String path) throws ListIsEmptyException, NoAvailableConversionException {
        if (tag instanceof CompoundTag) {
            this.updateCompoundSelector((CompoundTag)tag, path);
            return;
        }
        ConversionPair pair = this.getPair(tag, path);
        this.addPathSelector(path, (self, nbt, json, path1, direction) -> pair);
    }

    private boolean safeUpdateSelector(Tag tag, String path) {
        try {
            this.updateSelector(tag, path);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void updateCompoundSelector(CompoundTag nbt, String path) throws ListIsEmptyException, NoAvailableConversionException {
        for (String key : nbt.m_128431_()) {
            this.updateSelector(nbt.m_128423_(key), path + "." + key);
        }
    }

    private ConversionPair getPair(Tag tag, String path) throws ListIsEmptyException, NoAvailableConversionException {
        ConversionPair result = null;
        result = this.getPrimitivePair(tag, path);
        if (result != null) {
            return result;
        }
        result = this.getCollectionPair(tag, path);
        if (result != null) {
            return result;
        }
        throw new NoAvailableConversionException(tag.getClass(), path);
    }

    private ConversionPair getPrimitivePair(Tag tag, String path) {
        if (tag instanceof StringTag) {
            return this.getPair("str");
        }
        if (tag instanceof IntTag) {
            return this.getPair("int");
        }
        if (tag instanceof LongTag) {
            return this.getPair("long");
        }
        if (tag instanceof DoubleTag) {
            return this.getPair("double");
        }
        if (tag instanceof FloatTag) {
            return this.getPair("float");
        }
        if (tag instanceof ShortTag) {
            return this.getPair("short");
        }
        if (tag instanceof ByteTag) {
            if (this.isMarkedAsBoolTag(path)) {
                return this.getPair("bool");
            }
            return this.getPair("byte");
        }
        return null;
    }

    private ConversionPair getCollectionPair(Tag tag, String path) throws ListIsEmptyException, NoAvailableConversionException {
        if (tag instanceof IntArrayTag) {
            return this.getPair("int_array");
        }
        if (tag instanceof LongArrayTag) {
            return this.getPair("long_array");
        }
        if (tag instanceof ByteArrayTag) {
            return this.getPair("byte_array");
        }
        if (tag instanceof ListTag) {
            ListTag lTag = (ListTag)tag;
            if (lTag.isEmpty()) {
                throw new ListIsEmptyException(tag, path);
            }
            Tag t = lTag.get(0);
            ConversionPair pair = this.getPair(t, path);
            return new ListPair(pair);
        }
        return null;
    }

    @Generated
    public Tag getTemplate() {
        return this.template;
    }

    @Generated
    public HashSet<String> getBoolTags() {
        return this.boolTags;
    }
}

