/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.util.projectile;

import com.mojang.math.Vector3f;
import java.util.function.Function;
import javax.annotation.Nullable;
import kasuga.lib.core.client.animation.neo_neo.VectorUtil;
import kasuga.lib.core.client.render.texture.Vec2f;
import kasuga.lib.core.util.projectile.Panel;
import kasuga.lib.core.util.projectile.Ray;
import lombok.Generated;
import net.minecraft.world.phys.Vec3;

public class Grid {
    private final Panel panel;
    private Vector3f xAxis;
    private Vector3f yAxis;
    private Vector3f o;
    private Vec2f xAxis2d;
    private Vec2f yAxis2d;

    public Grid(Panel panel, Vector3f o, Vec2f xAxis, Vec2f yAxis) {
        this.panel = panel;
        this.o = o;
        this.xAxis2d = xAxis;
        this.yAxis2d = yAxis;
        this.xAxis = panel.map(xAxis);
        this.yAxis = panel.map(yAxis);
    }

    public Grid(Panel panel, Vector3f o) {
        this(panel, o, new Vec2f(1.0f, 0.0f), new Vec2f(0.0f, 1.0f));
    }

    private Grid(Panel panel, Vector3f o, Vector3f xAxis, Vector3f yAxis, Vec2f xAxis2d, Vec2f yAxis2d) {
        this.panel = panel;
        this.o = o;
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.xAxis2d = xAxis2d;
        this.yAxis2d = yAxis2d;
    }

    public void setO(Vector3f o) {
        this.o = o;
    }

    public Vector3f getO() {
        return this.o;
    }

    public Grid copy() {
        return new Grid(this.panel, this.o, this.xAxis, this.yAxis, this.xAxis2d, this.yAxis2d);
    }

    public Vector3f get(Vec2f vec) {
        return this.get(vec.x(), vec.y());
    }

    public Vector3f get(float x, float y) {
        Vector3f result = this.o.m_122281_();
        Vector3f x3d = this.xAxis.m_122281_();
        x3d.m_122261_(x);
        result.m_122253_(x3d);
        Vector3f y3d = this.yAxis.m_122281_();
        y3d.m_122261_(y);
        result.m_122253_(y3d);
        return result;
    }

    public Vec2f get(Vector3f vec) {
        float pi = (float)Math.PI;
        Vector3f offset = vec.m_122281_();
        offset.m_122267_(this.o);
        Vec2f offset2d = this.panel.map(offset);
        Function<Float, Float> mapper = angle -> Float.valueOf(angle.floatValue() > pi ? 2.0f * pi - angle.floatValue() : angle.floatValue());
        float sina = this.vecSine(vec, this.yAxis);
        float sinb = this.vecSine(vec, this.xAxis);
        float sinc = this.vecSine(this.xAxis, this.yAxis);
        float cLen = this.len(vec);
        float bLen = cLen / sinc * sinb;
        float aLen = cLen / sinc * sina;
        return new Vec2f(aLen / this.xAxis2d.length(), bLen / this.yAxis2d.length());
    }

    public float vecSine(Vector3f vec1, Vector3f vec2) {
        Vector3f a = vec1.m_122281_();
        a.m_122278_();
        Vector3f b = vec2.m_122281_();
        b.m_122278_();
        a.m_122279_(b);
        return this.len(a);
    }

    public float len(Vector3f vector3f) {
        return (float)Math.sqrt(vector3f.m_122239_() * vector3f.m_122239_() + vector3f.m_122260_() * vector3f.m_122260_() + vector3f.m_122269_() * vector3f.m_122269_());
    }

    public void flex(float xScale, float yScale) {
        this.xAxis.m_122261_(xScale);
        this.yAxis.m_122261_(yScale);
        this.xAxis2d.set(this.xAxis2d.x() * xScale, this.xAxis2d.y() * xScale);
        this.yAxis2d.set(this.yAxis2d.x() * yScale, this.yAxis2d.y() * yScale);
    }

    public void flex(float scale) {
        this.flex(scale, scale);
    }

    public void rot(float rad) {
        this.xAxis2d = this.xAxis2d.rotate(rad);
        this.yAxis2d = this.yAxis2d.rotate(rad);
        this.xAxis = this.panel.map(this.xAxis2d);
        this.yAxis = this.panel.map(this.yAxis2d);
    }

    public void rotDeg(float deg) {
        this.rot(VectorUtil.translateDegAndRad(deg, false));
    }

    public Ray getNormalRay(float x, float y) {
        Vector3f source = this.get(x, y);
        return new Ray(source, new Vector3f(this.panel.normal));
    }

    public Ray getNormalRay(Vec2f pos) {
        return this.getNormalRay(pos.x(), pos.y());
    }

    @Nullable
    public Vec2f rayToPoint(Ray ray) {
        Vector3f hitPoint = ray.getHitPoint(this.panel);
        if (!ray.pointOnRay(hitPoint)) {
            return null;
        }
        return this.get(hitPoint);
    }

    public String toString() {
        return "Grid<\n    " + this.panel + ", \n    " + this.o + ", \n    " + this.xAxis2d + ", " + this.yAxis2d + ",\n    " + this.xAxis + ", " + this.yAxis + "\n>";
    }

    public static void main(String[] args) {
        Vec3 normal = new Vec3(1.0, 1.0, 1.0);
        Panel panel = new Panel(Vec3.f_82478_, normal);
        Vec2f xo2f = new Vec2f(1.0f, 0.0f);
        Vec2f yo2f = new Vec2f(0.0f, 1.0f);
        Grid grid = new Grid(panel, Vector3f.f_176763_, xo2f, yo2f);
        grid.rotDeg(80.0f);
        Vector3f vector3f = grid.get(new Vec2f(0.5f, 0.5f));
        Vec2f vec2f = grid.get(vector3f);
        System.out.println(grid);
        System.out.println(vector3f);
        System.out.println(vec2f);
    }

    @Generated
    public Panel getPanel() {
        return this.panel;
    }

    @Generated
    public Vector3f getXAxis() {
        return this.xAxis;
    }

    @Generated
    public Vector3f getYAxis() {
        return this.yAxis;
    }

    @Generated
    public Vec2f getXAxis2d() {
        return this.xAxis2d;
    }

    @Generated
    public Vec2f getYAxis2d() {
        return this.yAxis2d;
    }
}

