/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.util.projectile;

import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import kasuga.lib.core.client.render.texture.Vec2f;
import kasuga.lib.core.util.projectile.PanelRenderer;
import kasuga.lib.core.util.projectile.Ray;
import lombok.Generated;
import net.minecraft.world.phys.Vec3;

public class Panel {
    public static PanelRenderer test = null;
    public Vec3 normal;
    public double constant;

    public Panel(Panel panel) {
        this.normal = panel.normal;
        this.constant = panel.constant;
    }

    private Panel(Vec3 normal, double constant) {
        this.normal = normal;
        this.constant = constant;
    }

    public Panel(Vector3f pos1, Vector3f pos2, Vector3f pos3) {
        this(new Vec3(pos3), new Vec3(pos1).m_82537_(new Vec3(pos2)));
    }

    public Panel(Vector3f point, Vector3f normal) {
        this.normal = new Vec3(normal);
        this.constant = point.m_122276_(normal);
    }

    public Panel(Vec3 point, Vec3 normal) {
        this.normal = normal;
        this.constant = point.m_82526_(normal);
    }

    public Panel(Vec3 pos1, Vec3 pos2, Vec3 pos3) {
        this(pos3, pos1.m_82537_(pos2));
    }

    public Panel copy() {
        return new Panel(this);
    }

    public Panel moveAndCopy(Vec3 point) {
        return new Panel(this.normal, point);
    }

    public void moveTo(Vec3 point) {
        this.constant = point.m_82526_(this.normal);
    }

    public Panel offset(Vec3 offset) {
        double offsetConst = offset.m_82526_(this.normal);
        return new Panel(this.normal.m_82549_(offset), this.constant + offsetConst);
    }

    public Panel rotate(Quaternion quaternion, Vec3 referencePoint) {
        assert (this.isPointOnPanel(referencePoint));
        Vector3f neoNormal = new Vector3f(this.normal);
        neoNormal.m_122251_(quaternion);
        return new Panel(referencePoint, new Vec3(neoNormal));
    }

    public Panel rotateDeg(Vector3f rotationDeg, Vec3 referencePoint) {
        return this.rotate(Quaternion.m_175225_((Vector3f)rotationDeg), referencePoint);
    }

    public Panel rotate(Vector3f rotation, Vec3 referencePoint) {
        return this.rotate(Quaternion.m_175232_((Vector3f)rotation), referencePoint);
    }

    public Panel transform(Matrix4f matrix) {
        Vector4f vector4f = new Vector4f((float)this.normal.m_7096_(), (float)this.normal.m_7098_(), (float)this.normal.m_7094_(), (float)this.constant);
        vector4f.m_123607_(matrix);
        return new Panel(new Vec3((double)vector4f.m_123601_(), (double)vector4f.m_123615_(), (double)vector4f.m_123616_()), vector4f.m_123617_());
    }

    public Panel reverse() {
        return new Panel(this.normal.m_82548_(), this.constant);
    }

    public Vector3f getNormal() {
        return new Vector3f(this.normal);
    }

    public boolean isPointOnPanel(Vec3 point) {
        return this.normal.m_82526_(point) == this.constant;
    }

    public boolean isPointOnPanel(Vector3f point) {
        return this.isPointOnPanel(new Vec3(point));
    }

    public boolean isVecHitPanel(Vec3 vec) {
        return vec.m_82526_(this.normal) == 0.0;
    }

    public boolean isVecHitPanel(Vector3f vec) {
        return this.isVecHitPanel(new Vec3(vec));
    }

    public Vec3 getHitPoint(Vec3 pos, Vec3 forward) {
        if (this.isPointOnPanel(pos)) {
            return pos;
        }
        assert (this.valid());
        assert (this.isVecHitPanel(forward));
        Vec3 referencePoint = this.defaultReferencePoint();
        double d = referencePoint.m_82546_(pos).m_82526_(this.normal) / forward.m_82526_(this.normal);
        return forward.m_82490_(d).m_82549_(pos);
    }

    public Vector3f getHitPoint(Vector3f pos, Vector3f forward) {
        return new Vector3f(this.getHitPoint(new Vec3(pos), new Vec3(forward)));
    }

    public Vector3f getHitPoint(Ray ray) {
        return this.getHitPoint(ray.getSource(), ray.getForward());
    }

    public Vec3 defaultReferencePoint() {
        assert (this.valid());
        if (this.parallelWithXOZ()) {
            return new Vec3(1.0, this.getY(1.0, 1.0), 1.0);
        }
        if (this.parallelWithYOZ()) {
            return new Vec3(this.getX(1.0, 1.0), 1.0, 1.0);
        }
        return new Vec3(1.0, 1.0, this.getZ(1.0, 1.0));
    }

    public boolean valid() {
        return !this.normal.equals((Object)Vec3.f_82478_);
    }

    public boolean parallelWith(Vec3 normal) {
        return this.normal.m_82537_(normal).equals((Object)Vec3.f_82478_);
    }

    public boolean parallel(Vec3 vec3) {
        return this.normal.m_82526_(vec3) == 0.0;
    }

    public boolean parallel(Vector3f vector3f) {
        return this.normal.m_82526_(new Vec3(vector3f)) == 0.0;
    }

    public boolean parallelWithXOY() {
        return this.parallelWith(new Vec3(0.0, 0.0, 1.0));
    }

    public boolean parallelWithXOZ() {
        return this.parallelWith(new Vec3(0.0, 1.0, 0.0));
    }

    public boolean parallelWithYOZ() {
        return this.parallelWith(new Vec3(1.0, 0.0, 0.0));
    }

    public Vec3 yAxisIntersection() {
        return new Vec3(0.0, this.getY(0.0, 0.0), 0.0);
    }

    public Vec3 xAxisIntersection() {
        return new Vec3(this.getX(0.0, 0.0), 0.0, 0.0);
    }

    public Vec3 zAxisIntersection() {
        return new Vec3(0.0, 0.0, this.getZ(0.0, 0.0));
    }

    public double getX(double y, double z) {
        return (this.constant - this.normal.m_7098_() * y - this.normal.m_7094_() * z) / this.normal.m_7096_();
    }

    public double getY(double x, double z) {
        return (this.constant - this.normal.m_7096_() * x - this.normal.m_7094_() * z) / this.normal.m_7098_();
    }

    public double getZ(double x, double y) {
        return (this.constant - this.normal.m_7096_() * x - this.normal.m_7098_() * y) / this.normal.m_7094_();
    }

    public Vector3f map(Vec2f vec) {
        Vec2f pitchAndYaw = Panel.getPitchAndYaw(this.normal);
        Quaternion quaternion = Quaternion.m_175228_((float)0.0f, (float)pitchAndYaw.y(), (float)pitchAndYaw.x());
        Vector3f vector3f = new Vector3f(vec.x(), 0.0f, vec.y());
        vector3f.m_122251_(quaternion);
        return vector3f;
    }

    public Vec2f map(Vector3f vec) {
        assert (this.parallel(vec));
        Vec2f pitchAndYaw = Panel.getPitchAndYaw(this.normal).invert();
        Quaternion quaternion = Quaternion.m_175228_((float)0.0f, (float)pitchAndYaw.y(), (float)pitchAndYaw.x());
        Vector3f vec3f = vec.m_122281_();
        vec3f.m_122251_(quaternion);
        return new Vec2f(vec3f.m_122239_(), vec3f.m_122269_());
    }

    public static Vec2f getPitchAndYaw(Vec3 vec) {
        float pitch;
        float pi = (float)Math.PI;
        Vec2f horizontal = new Vec2f((float)vec.m_7096_(), (float)vec.m_7094_());
        if (horizontal.lengthSqr() == 0.0f) {
            return new Vec2f(vec.m_7098_() >= 0.0 ? 0.0f : pi, 0.0f);
        }
        float yaw = horizontal.getRotation();
        float vecLen = (float)vec.m_82553_();
        float f = pitch = vecLen == 0.0f ? 0.0f : (float)Math.asin(horizontal.length() / vecLen);
        if (vec.m_7098_() < 0.0) {
            pitch = pi - pitch;
        }
        return new Vec2f(-pitch, yaw);
    }

    public Quaternion getQuaternion() {
        return Panel.getQuaternion(this.normal);
    }

    public static Quaternion getQuaternion(Vec3 vec) {
        Vec2f pitchAndYaw = Panel.getPitchAndYaw(vec);
        Quaternion result = Quaternion.f_80118_.m_80161_();
        Quaternion yaw = Quaternion.m_175228_((float)0.0f, (float)pitchAndYaw.y(), (float)0.0f);
        Quaternion pitch = Quaternion.m_175228_((float)0.0f, (float)0.0f, (float)pitchAndYaw.x());
        result.m_80148_(yaw);
        result.m_80148_(pitch);
        return result;
    }

    public static Quaternion getQuaternion(Vector3f vector3f) {
        return Panel.getQuaternion(new Vec3(vector3f));
    }

    public Vector3f getRotationVector() {
        return this.getQuaternion().m_175217_();
    }

    public Vector3f getRotationDegVector() {
        return this.getQuaternion().m_175227_();
    }

    public String toString() {
        return "Panel<norm: " + this.normal.toString() + ", constant: " + this.constant + ">";
    }

    public static void main(String[] args) {
        Vec3 norm = new Vec3(0.0, 1.0, 0.0);
        Vec3 pos = Vec3.f_82478_;
        Panel panel = new Panel(pos, norm);
        panel = panel.rotateDeg(new Vector3f(0.0f, 0.0f, 90.0f), pos);
        System.out.println(panel);
        System.out.println(panel.getRotationDegVector());
    }

    @Generated
    public double getConstant() {
        return this.constant;
    }

    @Generated
    public void setNormal(Vec3 normal) {
        this.normal = normal;
    }
}

