/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.util.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.util.ArrayList;
import kasuga.lib.core.KasugaLibClient;
import kasuga.lib.core.client.model.AnimModelLoader;
import kasuga.lib.core.client.model.anim_model.AnimModel;
import kasuga.lib.core.client.render.SimpleColor;
import kasuga.lib.core.client.render.texture.Vec2f;
import kasuga.lib.core.util.Envs;
import kasuga.lib.core.util.LazyRecomputable;
import kasuga.lib.core.util.projectile.CameraTracker;
import kasuga.lib.core.util.projectile.Grid;
import kasuga.lib.core.util.projectile.Panel;
import kasuga.lib.core.util.projectile.Ray;
import lombok.Generated;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class PanelRenderer {
    private final Panel panel;
    private final Grid grid;
    private final Vec3 pos;
    private final CameraTracker tracker;
    private static final LazyRecomputable<AnimModel> panelModel = LazyRecomputable.of(() -> {
        AnimModel model = AnimModelLoader.INSTANCE.getModel(new ResourceLocation("kasuga_lib", "panel"));
        model.init();
        return model;
    });
    private static final LazyRecomputable<AnimModel> arrowModel = LazyRecomputable.of(() -> {
        AnimModel model = AnimModelLoader.INSTANCE.getModel(new ResourceLocation("kasuga_lib", "arrow"));
        model.init();
        return model;
    });
    private static final LazyRecomputable<AnimModel> arrow2Model = LazyRecomputable.of(() -> {
        AnimModel model = AnimModelLoader.INSTANCE.getModel(new ResourceLocation("kasuga_lib", "arrow_2"));
        model.init();
        return model;
    });
    public static Vector3f BASE_OFFSET = new Vector3f(0.5f, 0.5f, 0.5f);
    public static Vec3 BASE_OFFSET_2 = new Vec3(0.0, -1.61875, 0.0);
    public static Vec2f testRayPos = new Vec2f(0.5f, 0.5f);
    private final ArrayList<Ray> rays;

    @SubscribeEvent
    public static void renderToWorld(RenderLevelStageEvent event) {
        if (!Envs.isDevEnvironment()) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        PoseStack pose = event.getPoseStack();
        float partial = event.getPartialTick();
        RenderBuffers buffers = Minecraft.m_91087_().m_91269_();
        MultiBufferSource.BufferSource bufferSource = buffers.m_110104_();
        pose.m_85836_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Vec3 pos = player.m_20318_(partial);
        pose.m_85837_(-pos.m_7096_(), -pos.m_7098_(), -pos.m_7094_());
        KasugaLibClient.PANEL_RENDERERS.forEach(renderer -> {
            pose.m_85836_();
            renderer.render(pose, (MultiBufferSource)bufferSource, 240, 0, partial);
            pose.m_85849_();
        });
        pose.m_85849_();
    }

    public PanelRenderer(Vec3 normal, Vec3 pos) {
        this.panel = new Panel(pos, normal);
        this.grid = new Grid(this.panel, Vector3f.f_176763_);
        this.pos = pos;
        this.rays = new ArrayList();
        this.tracker = new CameraTracker(Minecraft.m_91087_().f_91065_, Minecraft.m_91087_().f_91063_.m_109153_());
    }

    public PanelRenderer(Panel panel, Vec3 pos, Grid grid, ArrayList<Ray> rays) {
        this.panel = panel;
        this.grid = grid;
        this.pos = pos;
        this.rays = rays;
        this.tracker = new CameraTracker(Minecraft.m_91087_().f_91065_, Minecraft.m_91087_().f_91063_.m_109153_());
    }

    public void render(PoseStack pose, MultiBufferSource buffer, int light, int overlay, float partial) {
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vector3f lookVec = camera.m_90596_();
        this.panel.setNormal(new Vec3(lookVec));
        Vec3 position = camera.m_90583_().m_82549_(BASE_OFFSET_2);
        this.rays.add(this.grid.getNormalRay(testRayPos));
        this.grid.setO(new Vector3f(position));
        Quaternion quaternion = this.panel.getQuaternion();
        pose.m_85836_();
        pose.m_85845_(quaternion);
        pose.m_85837_((double)(-BASE_OFFSET.m_122239_()), (double)BASE_OFFSET.m_122260_(), (double)(-BASE_OFFSET.m_122269_()));
        if (!this.panel.valid()) {
            panelModel.get().setColor(SimpleColor.fromRGBInt(Color.RED.getRGB()));
        } else {
            panelModel.get().setColor(SimpleColor.fromRGBInt(Color.WHITE.getRGB()));
        }
        panelModel.get().render(pose, buffer, light, overlay);
        if (!this.panel.valid()) {
            pose.m_85849_();
            return;
        }
        pose.m_85837_(0.0, (double)0.1f, 0.0);
        arrowModel.get().render(pose, buffer, light, overlay);
        Vec2f x = this.grid.getXAxis2d();
        Vec2f y = this.grid.getYAxis2d();
        arrow2Model.get().setAnimRot(new Vector3f(0.0f, x.getRotation() * 180.0f / (float)Math.PI, 0.0f));
        arrow2Model.get().render(pose, buffer, light, overlay);
        arrow2Model.get().setAnimRot(new Vector3f(0.0f, y.getRotation() * 180.0f / (float)Math.PI, 0.0f));
        arrow2Model.get().render(pose, buffer, light, overlay);
        pose.m_85849_();
        this.rays.clear();
    }

    @Generated
    public Panel getPanel() {
        return this.panel;
    }

    @Generated
    public Grid getGrid() {
        return this.grid;
    }

    @Generated
    public Vec3 getPos() {
        return this.pos;
    }

    @Generated
    public CameraTracker getTracker() {
        return this.tracker;
    }

    @Generated
    public ArrayList<Ray> getRays() {
        return this.rays;
    }
}

