/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.util.projectile;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import kasuga.lib.core.client.animation.neo_neo.VectorUtil;
import kasuga.lib.core.util.projectile.Panel;
import lombok.Generated;
import net.minecraft.world.phys.Vec3;

public class Ray {
    private final Vector3f source;
    private final Vector3f forward;

    public Ray(Vector3f source, Vector3f forward) {
        this.source = source;
        this.forward = forward;
        forward.m_122278_();
    }

    public Ray(Vec3 source, Vec3 forward) {
        this(new Vector3f(source), new Vector3f(forward));
    }

    public void changeDirection(Quaternion quaternion) {
        this.forward.m_122251_(quaternion);
    }

    public void offset(Vector3f offset) {
        this.source.m_122253_(offset);
    }

    public Vector3f get(float distance) {
        Vector3f result = this.source.m_122281_();
        Vector3f f = this.forward.m_122281_();
        f.m_122261_(distance);
        result.m_122253_(f);
        return result;
    }

    public Ray reflect(Vector3f normal, Vector3f neoSource) {
        Vec3 mir = VectorUtil.mirror(new Vec3(normal), new Vec3(this.forward));
        return new Ray(neoSource, new Vector3f(mir));
    }

    public Ray reflect(Panel panel) {
        if (panel.parallel(this.forward)) {
            return this;
        }
        if (panel.isPointOnPanel(this.source)) {
            return this.reflect(new Vector3f(panel.normal), this.source);
        }
        Vector3f hitPoint = panel.getHitPoint(this);
        Vector3f test = hitPoint.m_122281_();
        test.m_122267_(this.source);
        if (test.m_122276_(this.forward) < 0.0f) {
            return this;
        }
        return this.reflect(new Vector3f(panel.normal), hitPoint);
    }

    public Vector3f getHitPoint(Panel panel) {
        return panel.getHitPoint(this);
    }

    public boolean canHit(Panel panel) {
        if (panel.isPointOnPanel(this.source)) {
            return true;
        }
        if (panel.parallel(this.forward)) {
            return false;
        }
        Vector3f hitPoint = panel.getHitPoint(this);
        Vector3f test = hitPoint.m_122281_();
        test.m_122267_(this.source);
        return test.m_122276_(this.forward) >= 0.0f;
    }

    public boolean pointOnRay(Vector3f vector) {
        Vector3f offset = vector.m_122281_();
        offset.m_122267_(this.source);
        Vector3f test = offset.m_122281_();
        test.m_122279_(this.forward);
        if (!test.equals((Object)Vector3f.f_176763_)) {
            return false;
        }
        return offset.m_122276_(this.forward) >= 0.0f;
    }

    @Generated
    public Vector3f getSource() {
        return this.source;
    }

    @Generated
    public Vector3f getForward() {
        return this.forward;
    }
}

