/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.util.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import kasuga.lib.core.client.model.AnimModelLoader;
import kasuga.lib.core.client.model.anim_model.AnimModel;
import kasuga.lib.core.util.LazyRecomputable;
import kasuga.lib.core.util.projectile.Panel;
import kasuga.lib.core.util.projectile.PanelRenderer;
import kasuga.lib.core.util.projectile.Ray;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;

public class RayRenderer {
    private static final LazyRecomputable<AnimModel> arrowModel = LazyRecomputable.of(() -> {
        AnimModel model = AnimModelLoader.INSTANCE.getModel(new ResourceLocation("kasuga_lib", "arrow"));
        model.init();
        return model;
    });
    private final Ray ray;

    public RayRenderer(Ray ray) {
        this.ray = ray;
    }

    public void render(PoseStack pose, MultiBufferSource buffer, int light, int overlay) {
        pose.m_85836_();
        Vector3f source = this.ray.getSource();
        pose.m_85837_((double)source.m_122239_(), (double)source.m_122260_(), (double)source.m_122269_());
        Quaternion quaternion = Panel.getQuaternion(this.ray.getForward());
        pose.m_85845_(quaternion);
        pose.m_85837_((double)(-PanelRenderer.BASE_OFFSET.m_122239_()), (double)PanelRenderer.BASE_OFFSET.m_122260_(), (double)(-PanelRenderer.BASE_OFFSET.m_122269_()));
        arrowModel.get().render(pose, buffer, light, overlay);
        pose.m_85849_();
    }
}

