/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.example_env.block.bogey.pk209p;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.foundation.utility.NBTHelper;
import kasuga.lib.example_env.AllExampleBogey;
import kasuga.lib.example_env.ExampleMain;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class PK209PRenderer
extends BogeyRenderer {
    public static final PartialModel PK209P_MAIN = new PartialModel(PK209PRenderer.asBlockModelResource("bogey/pk209p/pk209p_main"));
    public static final PartialModel PK209P_WHEEL = new PartialModel(PK209PRenderer.asBlockModelResource("bogey/pk209p/pk209p_wheel"));
    public static final PartialModel PK209P_WHEEL2 = new PartialModel(PK209PRenderer.asBlockModelResource("bogey/pk209p/pk209p_wheel2"));
    public static final PartialModel PK209P_MOTORWHEEL = new PartialModel(PK209PRenderer.asBlockModelResource("bogey/pk209p/pk209_motorwheel"));

    private static ResourceLocation asBlockModelResource(String path) {
        return ExampleMain.testRegistry.asResource("block/" + path);
    }

    public void initialiseContraptionModelData(MaterialManager materialManager, CarriageBogey carriageBogey) {
        this.createModelInstance(materialManager, new PartialModel[]{PK209P_MAIN, PK209P_WHEEL, PK209P_WHEEL2, PK209P_MOTORWHEEL});
    }

    public BogeySizes.BogeySize getSize() {
        return AllExampleBogey.pk209p.getSize();
    }

    public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
        Direction direction = bogeyData.m_128441_("assembly_direction") ? (Direction)NBTHelper.readEnum((CompoundTag)bogeyData, (String)"assembly_direction", Direction.class) : Direction.NORTH;
        boolean inInstancedContraption = vb == null;
        BogeyRenderer.BogeyModelData main = this.getTransform(PK209P_MAIN, ms, inInstancedContraption);
        BogeyRenderer.BogeyModelData wheel = this.getTransform(PK209P_WHEEL, ms, inInstancedContraption);
        BogeyRenderer.BogeyModelData wheel2 = this.getTransform(PK209P_WHEEL2, ms, inInstancedContraption);
        BogeyRenderer.BogeyModelData motorWheel = this.getTransform(PK209P_MOTORWHEEL, ms, inInstancedContraption);
        if (direction == Direction.SOUTH || direction == Direction.EAST) {
            if (inContraption) {
                main.translate(0.0, 0.91, 0.0).render(ms, light, vb);
                ((BogeyRenderer.BogeyModelData)wheel.translate(0.0, 0.8, 1.2).rotateX((double)wheelAngle)).render(ms, light, vb);
                ((BogeyRenderer.BogeyModelData)wheel2.translate(0.0, 0.8, -1.2).rotateX((double)wheelAngle)).render(ms, light, vb);
                ((BogeyRenderer.BogeyModelData)motorWheel.translate(1.117, 0.82, 2.165).rotateX((double)wheelAngle * 3.256)).render(ms, light, vb);
            } else {
                ((BogeyRenderer.BogeyModelData)main.rotateY(180.0)).translate(0.0, 0.91, 0.0).render(ms, light, vb);
                ((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)wheel.translate(0.0, 0.8, -1.2).rotateY(180.0)).rotateX((double)(-wheelAngle))).render(ms, light, vb);
                ((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)wheel2.translate(0.0, 0.8, 1.2).rotateY(180.0)).rotateX((double)(-wheelAngle))).render(ms, light, vb);
                ((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)motorWheel.translate(-1.117, 0.82, -2.165).rotateY(180.0)).rotateX((double)(-wheelAngle) * 3.256)).render(ms, light, vb);
            }
        } else {
            main.translate(0.0, 0.91, 0.0).render(ms, light, vb);
            ((BogeyRenderer.BogeyModelData)wheel.translate(0.0, 0.8, 1.2).rotateX((double)wheelAngle)).render(ms, light, vb);
            ((BogeyRenderer.BogeyModelData)wheel2.translate(0.0, 0.8, -1.2).rotateX((double)wheelAngle)).render(ms, light, vb);
            ((BogeyRenderer.BogeyModelData)motorWheel.translate(1.117, 0.82, 2.165).rotateX((double)wheelAngle * 3.256)).render(ms, light, vb);
        }
    }
}

